/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.factory.operator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.verapdf.model.factory.operator.GraphicState;
import org.verapdf.model.factory.operator.OperatorParser;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.model.tools.transparency.TransparencyBehaviour;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public final class OperatorFactory {
    private static final Logger LOGGER = Logger.getLogger(OperatorFactory.class);
    private static final String MSG_UNEXPECTED_OBJECT_TYPE = "Unexpected type of object in tokens: ";
    private static final String GS_CLONE_MALFUNCTION = "GraphicsState clone function threw CloneNotSupportedException.";
    private boolean isLastParsedContainsTransparency = false;
    private static final Map<String, TransparencyBehaviour> PAINT_OPERATORS_WITHOUT_TEXT;
    private static final Set<String> PAINT_OPERATORS_TEXT;
    private static final Map<RenderingMode, TransparencyBehaviour> RENDERING_MODE;

    public boolean isLastParsedContainsTransparency() {
        return this.isLastParsedContainsTransparency;
    }

    public List<Operator> operatorsFromTokens(List<Object> pdfBoxTokens, PDInheritableResources resources, PDDocument document, PDFAFlavour flavour) {
        ArrayList<Operator> result = new ArrayList<Operator>();
        ArrayList<Object> arguments = new ArrayList<COSBase>();
        this.isLastParsedContainsTransparency = false;
        OperatorParser parser = new OperatorParser(document, flavour);
        for (Object pdfBoxToken : pdfBoxTokens) {
            if (pdfBoxToken instanceof COSBase) {
                arguments.add((COSBase)pdfBoxToken);
                continue;
            }
            if (pdfBoxToken instanceof org.apache.pdfbox.contentstream.operator.Operator) {
                try {
                    parser.parseOperator(result, (org.apache.pdfbox.contentstream.operator.Operator)pdfBoxToken, resources, arguments);
                    String parsedOperatorType = ((org.apache.pdfbox.contentstream.operator.Operator)pdfBoxToken).getName();
                    GraphicState graphicState = parser.getGraphicState();
                    if (PAINT_OPERATORS_WITHOUT_TEXT.containsKey(parsedOperatorType)) {
                        this.isLastParsedContainsTransparency |= PAINT_OPERATORS_WITHOUT_TEXT.get(parsedOperatorType).containsTransparency(graphicState);
                    } else {
                        RenderingMode renderingMode = graphicState.getRenderingMode();
                        if (PAINT_OPERATORS_TEXT.contains(parsedOperatorType) && RENDERING_MODE.containsKey(renderingMode)) {
                            this.isLastParsedContainsTransparency |= RENDERING_MODE.get(renderingMode).containsTransparency(graphicState);
                        }
                    }
                }
                catch (CloneNotSupportedException e) {
                    LOGGER.debug((Object)("GraphicsState clone issues for pdfBoxToken:" + pdfBoxToken));
                    LOGGER.debug((Object)GS_CLONE_MALFUNCTION, (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.debug((Object)e);
                }
                arguments = new ArrayList();
                continue;
            }
            LOGGER.debug((Object)(MSG_UNEXPECTED_OBJECT_TYPE + pdfBoxToken.getClass().getName()));
        }
        return result;
    }

    static {
        HashMap<String, TransparencyBehaviour> aMap = new HashMap<String, TransparencyBehaviour>();
        TransparencyBehaviour fill = TransparencyBehaviour.createFillInstance();
        TransparencyBehaviour fillXObject = TransparencyBehaviour.createFillXObjectInstance();
        TransparencyBehaviour fillCS = TransparencyBehaviour.createFillColorSpaceInstance();
        TransparencyBehaviour strokeCS = TransparencyBehaviour.createStrokeColorSpaceInstance();
        TransparencyBehaviour fillStrokeCS = TransparencyBehaviour.createFillStrokeColorSpaceInstance();
        aMap.put("S", strokeCS);
        aMap.put("s", strokeCS);
        aMap.put("f", fillCS);
        aMap.put("F", fillCS);
        aMap.put("f*", fillCS);
        aMap.put("B", fillStrokeCS);
        aMap.put("B*", fillStrokeCS);
        aMap.put("b", fillStrokeCS);
        aMap.put("b*", fillStrokeCS);
        aMap.put("sh", fill);
        aMap.put("Do", fillXObject);
        aMap.put("EI", fill);
        PAINT_OPERATORS_WITHOUT_TEXT = Collections.unmodifiableMap(aMap);
        PAINT_OPERATORS_TEXT = new HashSet<String>(Arrays.asList("Tj", "'", "\"", "TJ"));
        aMap = new HashMap();
        TransparencyBehaviour strokeCSFont = TransparencyBehaviour.createStrokeColorSpaceFontInstance();
        TransparencyBehaviour fillCSFont = TransparencyBehaviour.createFillColorSpaceFontInstance();
        TransparencyBehaviour fillStrokeCSFont = TransparencyBehaviour.createFillStrokeColorSpaceFontInstance();
        aMap.put((String)RenderingMode.FILL, fillCSFont);
        aMap.put((String)RenderingMode.STROKE, strokeCSFont);
        aMap.put((String)RenderingMode.FILL_STROKE, fillStrokeCSFont);
        aMap.put((String)RenderingMode.FILL_CLIP, fillCSFont);
        aMap.put((String)RenderingMode.STROKE_CLIP, strokeCSFont);
        aMap.put((String)RenderingMode.FILL_STROKE_CLIP, fillStrokeCSFont);
        RENDERING_MODE = Collections.unmodifiableMap(aMap);
    }
}

