/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.images;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObjectProxy;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.external.JPEG2000;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.impl.pb.cos.PBCosRenderingIntent;
import org.verapdf.model.impl.pb.external.PBoxJPEG2000;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXObject;
import org.verapdf.model.pdlayer.PDColorSpace;
import org.verapdf.model.pdlayer.PDXImage;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDXImage
extends PBoxPDXObject
implements PDXImage {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDXImage.class);
    public static final String X_IMAGE_TYPE = "PDXImage";
    public static final String IMAGE_CS = "imageCS";
    public static final String ALTERNATES = "Alternates";
    public static final String INTENT = "Intent";
    public static final String JPX_STREAM = "jpxStream";
    private final boolean interpolate;
    private List<JPEG2000> jpeg2000List = null;
    private PDColorSpace colorSpaceFromImage = null;

    public PBoxPDXImage(PDImageXObjectProxy simplePDObject, PDInheritableResources resources, PDDocument document, PDFAFlavour flavour) {
        this(simplePDObject, resources, X_IMAGE_TYPE, document, flavour);
    }

    protected PBoxPDXImage(PDImageXObjectProxy simplePDObject, PDInheritableResources resources, String type, PDDocument document, PDFAFlavour flavour) {
        super((COSObjectable)simplePDObject, resources, type, document, flavour);
        this.interpolate = simplePDObject.getInterpolate();
    }

    public Boolean getInterpolate() {
        return this.interpolate;
    }

    public Boolean getcontainsAlternates() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.getPDFName((String)ALTERNATES));
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Intent": {
                return this.getIntent();
            }
            case "imageCS": {
                return this.getImageCS();
            }
            case "Alternates": {
                return this.getAlternates();
            }
            case "jpxStream": {
                return this.getJPXStream();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosRenderingIntent> getIntent() {
        COSDictionary imageStream = (COSDictionary)this.simplePDObject.getCOSObject();
        COSName intent = imageStream.getCOSName(COSName.getPDFName((String)INTENT));
        if (intent != null) {
            ArrayList<PBCosRenderingIntent> intents = new ArrayList<PBCosRenderingIntent>(1);
            intents.add(new PBCosRenderingIntent(intent));
            return Collections.unmodifiableList(intents);
        }
        return Collections.emptyList();
    }

    private List<PDColorSpace> getImageCS() {
        PDImageXObjectProxy image;
        if (this.jpeg2000List == null) {
            this.jpeg2000List = this.parseJPXStream();
        }
        if (!(image = (PDImageXObjectProxy)this.simplePDObject).isStencil()) {
            try {
                PDColorSpace buffer = ColorSpaceFactory.getColorSpace(image.getColorSpace(), null, this.resources, 0, false, this.document, this.flavour);
                if (buffer == null) {
                    buffer = this.colorSpaceFromImage;
                }
                if (buffer != null) {
                    ArrayList<PDColorSpace> colorSpaces = new ArrayList<PDColorSpace>(1);
                    colorSpaces.add(buffer);
                    return Collections.unmodifiableList(colorSpaces);
                }
            }
            catch (IOException e) {
                LOGGER.debug((Object)("Could not obtain Image XObject color space. " + e.getMessage()), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private List<? extends PDXImage> getAlternates() {
        ArrayList<PDXImage> alternates = new ArrayList<PDXImage>();
        try (COSStream imageStream = ((PDImageXObjectProxy)this.simplePDObject).getCOSStream();){
            COSBase buffer = imageStream.getDictionaryObject(COSName.getPDFName((String)ALTERNATES));
            this.addAlternates(alternates, buffer, ((PDImageXObjectProxy)this.simplePDObject).getResources());
        }
        catch (IOException excep) {
            excep.printStackTrace();
        }
        return alternates;
    }

    private void addAlternates(List<PDXImage> alternates, COSBase buffer, PDResources resourcesToAdd) {
        if (buffer instanceof COSArray) {
            for (COSBase element : (COSArray)buffer) {
                if (element instanceof COSObject) {
                    element = ((COSObject)element).getObject();
                }
                if (!(element instanceof COSDictionary)) continue;
                this.addAlternate(alternates, (COSDictionary)element, resourcesToAdd);
            }
        }
    }

    private void addAlternate(List<PDXImage> alternates, COSDictionary buffer, PDResources resourcesToAdd) {
        COSBase alternatesImages = buffer.getDictionaryObject(COSName.IMAGE);
        if (alternatesImages instanceof COSStream) {
            PDStream stream = new PDStream((COSStream)alternatesImages);
            PDImageXObjectProxy imageXObject = new PDImageXObjectProxy(stream, resourcesToAdd);
            alternates.add(new PBoxPDXImage(imageXObject, this.resources, this.document, this.flavour));
        }
    }

    private List<JPEG2000> getJPXStream() {
        if (this.jpeg2000List == null) {
            this.jpeg2000List = this.parseJPXStream();
        }
        return this.jpeg2000List;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<JPEG2000> parseJPXStream() {
        try {
            PDStream stream = ((PDImageXObjectProxy)this.simplePDObject).getPDStream();
            List filters = stream.getFilters();
            if (filters == null) return Collections.emptyList();
            if (!filters.contains(COSName.JPX_DECODE)) return Collections.emptyList();
            try (InputStream image = stream.getStream().getFilteredStream();){
                ArrayList<PBoxJPEG2000> list2 = new ArrayList<PBoxJPEG2000>(1);
                PBoxJPEG2000 jpeg2000 = PBoxJPEG2000.fromStream(image, this.document, this.flavour);
                this.colorSpaceFromImage = jpeg2000.getImageColorSpace();
                list2.add(jpeg2000);
                List<JPEG2000> list = Collections.unmodifiableList(list2);
                return list;
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Problems with stream obtain.", (Throwable)e);
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsTransparency() {
        if (this.simplePDObject == null) {
            return false;
        }
        COSBase base = this.simplePDObject.getCOSObject();
        if (!(base instanceof COSStream)) return false;
        try (COSStream stream = (COSStream)base;){
            if (stream.getDictionaryObject(COSName.SMASK) instanceof COSStream) {
                boolean bl = true;
                return bl;
            }
            COSBase sMaskInData = stream.getDictionaryObject(COSName.getPDFName((String)"SMaskInData"));
            if (!(sMaskInData instanceof COSNumber)) return false;
            boolean bl = ((COSNumber)sMaskInData).doubleValue() > 0.0;
            return bl;
        }
        catch (IOException excep) {
            excep.printStackTrace();
        }
        return false;
    }
}

