/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.external;

import java.io.IOException;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.log4j.Logger;
import org.verapdf.model.external.TrueTypeFontProgram;
import org.verapdf.model.impl.pb.external.PBoxFontProgram;

public class PBoxTrueTypeFontProgram
extends PBoxFontProgram
implements TrueTypeFontProgram {
    private static final Logger LOGGER = Logger.getLogger(PBoxTrueTypeFontProgram.class);
    public static final String TRUE_TYPE_PROGRAM_TYPE = "TrueTypeFontProgram";
    private Long nrCmaps = 0L;
    private Boolean cmap30Present = Boolean.FALSE;
    private Boolean cmap31Present = Boolean.FALSE;
    private Boolean cmap10Present = Boolean.FALSE;
    private Boolean isSymbolic;

    public PBoxTrueTypeFontProgram(FontBoxFont fontProgram, Boolean isSymbolic) {
        super(fontProgram, TRUE_TYPE_PROGRAM_TYPE);
        this.isSymbolic = isSymbolic;
        try {
            CmapTable cmap = ((TrueTypeFont)this.fontProgram).getCmap();
            if (cmap != null) {
                CmapSubtable[] cmaps = cmap.getCmaps();
                this.nrCmaps = cmaps.length;
                for (CmapSubtable cmapSubtable : cmaps) {
                    int platformId = cmapSubtable.getPlatformId();
                    int platformEncodingId = cmapSubtable.getPlatformEncodingId();
                    this.cmap30Present = platformId == 3 && platformEncodingId == 0;
                    this.cmap31Present = platformId == 3 && platformEncodingId == 1;
                    this.cmap10Present = platformId == 1 && platformEncodingId == 0;
                }
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)e);
        }
    }

    public Long getnrCmaps() {
        return this.nrCmaps;
    }

    public Boolean getisSymbolic() {
        return this.isSymbolic;
    }

    public Boolean getcmap30Present() {
        return this.cmap30Present;
    }

    public Boolean getcmap31Present() {
        return this.cmap31Present;
    }

    public Boolean getcmap10Present() {
        return this.cmap10Present;
    }
}

