/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.pagenavigation.PDTransition;
import org.verapdf.features.objects.PageFeaturesObjectAdapter;
import org.verapdf.features.pb.tools.PBAdapterHelper;

public class PBPageFeaturesObjectAdapter
implements PageFeaturesObjectAdapter {
    private PDPage page;
    private String label;
    private String thumb;
    private Set<String> annotsId;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> propertiesChild;
    private int index;
    private Double scaling;
    private PDTransition transition;
    private List<String> errors;

    public PBPageFeaturesObjectAdapter(PDPage page, String label, String thumb, Set<String> annotsId, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild, int index) {
        this.page = page;
        this.label = label;
        this.thumb = thumb;
        this.annotsId = annotsId;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
        this.index = index;
        if (page != null) {
            this.transition = this.page.getTransition();
            COSBase base = page.getCOSObject().getDictionaryObject(COSName.getPDFName((String)"PZ"));
            if (base != null) {
                while (base instanceof COSObject) {
                    base = ((COSObject)base).getObject();
                }
                if (base instanceof COSNumber) {
                    COSNumber number = (COSNumber)base;
                    this.scaling = number.doubleValue();
                } else {
                    this.errors = new ArrayList<String>();
                    this.errors.add("Scaling is not a number");
                }
            }
        }
    }

    public String getThumb() {
        return this.thumb;
    }

    public Set<String> getAnnotsId() {
        return this.annotsId;
    }

    public Set<String> getExtGStateChild() {
        return this.extGStateChild;
    }

    public Set<String> getColorSpaceChild() {
        return this.colorSpaceChild;
    }

    public Set<String> getPatternChild() {
        return this.patternChild;
    }

    public Set<String> getShadingChild() {
        return this.shadingChild;
    }

    public Set<String> getXObjectChild() {
        return this.xobjectChild;
    }

    public Set<String> getFontChild() {
        return this.fontChild;
    }

    public Set<String> getPropertiesChild() {
        return this.propertiesChild;
    }

    public int getIndex() {
        return this.index;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTransitionStyle() {
        return this.transition == null ? null : this.transition.getStyle();
    }

    public double[] getMediaBox() {
        if (this.page != null) {
            return PBAdapterHelper.parseRectangle(this.page.getMediaBox());
        }
        return null;
    }

    public double[] getCropBox() {
        if (this.page != null) {
            return PBAdapterHelper.parseRectangle(this.page.getCropBox());
        }
        return null;
    }

    public double[] getTrimBox() {
        if (this.page != null) {
            return PBAdapterHelper.parseRectangle(this.page.getTrimBox());
        }
        return null;
    }

    public double[] getBleedBox() {
        if (this.page != null) {
            return PBAdapterHelper.parseRectangle(this.page.getBleedBox());
        }
        return null;
    }

    public double[] getArtBox() {
        if (this.page != null) {
            return PBAdapterHelper.parseRectangle(this.page.getArtBox());
        }
        return null;
    }

    public Long getRotation() {
        if (this.page != null) {
            return this.page.getRotation();
        }
        return null;
    }

    public Double getScaling() {
        return this.scaling;
    }

    public InputStream getMetadataStream() {
        if (this.page != null) {
            return PBAdapterHelper.getMetadataStream(this.page.getMetadata());
        }
        return null;
    }

    public boolean isPDFObjectPresent() {
        return this.page != null;
    }

    public List<String> getErrors() {
        return this.errors == null ? Collections.emptyList() : Collections.unmodifiableList(this.errors);
    }
}

