/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.verapdf.features.objects.OutputIntentFeaturesObjectAdapter;

public class PBOutputIntentsFeaturesObjectAdapter
implements OutputIntentFeaturesObjectAdapter {
    private PDOutputIntent outInt;
    private String iccProfileID;
    private String subtype;
    private List<String> errors;

    public PBOutputIntentsFeaturesObjectAdapter(PDOutputIntent outInt, String iccProfileID) {
        COSBase base;
        this.outInt = outInt;
        this.iccProfileID = iccProfileID;
        if (this.outInt != null && (base = this.outInt.getCOSObject()) instanceof COSDictionary) {
            COSDictionary dict = (COSDictionary)base;
            COSBase baseType = dict.getDictionaryObject(COSName.S);
            while (baseType instanceof COSObject) {
                baseType = ((COSObject)baseType).getObject();
            }
            if (baseType != null) {
                if (baseType instanceof COSName) {
                    this.subtype = ((COSName)baseType).getName();
                } else {
                    this.errors = new ArrayList<String>();
                    this.errors.add("Subtype is not of Name type");
                }
            }
        }
    }

    public String getICCProfileID() {
        return this.iccProfileID;
    }

    public String getSubType() {
        return this.subtype;
    }

    public String getOutputCondition() {
        if (this.outInt != null) {
            return this.outInt.getOutputCondition();
        }
        return null;
    }

    public String getOutputConditionIdentifier() {
        if (this.outInt != null) {
            return this.outInt.getOutputConditionIdentifier();
        }
        return null;
    }

    public String getRegistryName() {
        if (this.outInt != null) {
            return this.outInt.getRegistryName();
        }
        return null;
    }

    public String getInfo() {
        if (this.outInt != null) {
            return this.outInt.getInfo();
        }
        return null;
    }

    public boolean isPDFObjectPresent() {
        return this.outInt != null;
    }

    public List<String> getErrors() {
        return this.errors == null ? Collections.emptyList() : Collections.unmodifiableList(this.errors);
    }
}

