/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public final class PBAdapterHelper {
    private static final Logger LOGGER = Logger.getLogger(PBAdapterHelper.class);

    private PBAdapterHelper() {
    }

    public static String getStringFromBase(COSBase baseParam) {
        COSBase base = baseParam;
        while (base instanceof COSObject) {
            base = ((COSObject)base).getObject();
        }
        if (base instanceof COSString) {
            COSString str = (COSString)base;
            return str.isHex() ? str.toHexString() : str.getString();
        }
        return null;
    }

    public static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((length = is.read(bytes)) != -1) {
            baos.write(bytes, 0, length);
        }
        return baos.toByteArray();
    }

    public static InputStream getMetadataStream(PDMetadata metadata) {
        COSStream stream;
        if (metadata != null && (stream = metadata.getStream()) != null) {
            try {
                return stream.getUnfilteredStream();
            }
            catch (IOException e) {
                LOGGER.debug((Object)"Error while obtaining unfiltered metadata stream", (Throwable)e);
            }
        }
        return null;
    }

    public static double[] parseFloatMatrix(float[][] array) {
        if (array != null) {
            double[] res = new double[6];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 2; ++j) {
                    res[2 * i + j] = array[i][j];
                }
            }
            return res;
        }
        return null;
    }

    public static double[] castFloatArrayToDouble(float[] array) {
        if (array != null) {
            double[] res = new double[array.length];
            for (int i = 0; i < array.length; ++i) {
                res[i] = array[i];
            }
            return res;
        }
        return null;
    }

    public static double[] parseRectangle(PDRectangle rect) {
        if (rect != null) {
            double[] res = new double[]{rect.getLowerLeftX(), rect.getLowerLeftY(), rect.getUpperRightX(), rect.getUpperRightY()};
            return res;
        }
        return null;
    }
}

