/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.verapdf.features.objects.InteractiveFormFieldFeaturesObjectAdapter;

public class PBInteractiveFormFieldFeaturesObjectAdapter
implements InteractiveFormFieldFeaturesObjectAdapter {
    private final PDField formField;

    public PBInteractiveFormFieldFeaturesObjectAdapter(PDField formField) {
        this.formField = formField;
    }

    public String getFullyQualifiedName() {
        return this.formField.getFullyQualifiedName();
    }

    public String getValue() {
        COSBase value = this.formField.getV();
        if (value instanceof COSBoolean) {
            return String.valueOf(((COSBoolean)value).getValue());
        }
        if (value instanceof COSString) {
            return ((COSString)value).getString();
        }
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        if (value instanceof COSInteger) {
            return String.valueOf(((COSInteger)value).longValue());
        }
        if (value instanceof COSNumber) {
            return String.valueOf(((COSNumber)value).doubleValue());
        }
        if (value instanceof COSArray) {
            return "--COSArray--";
        }
        if (value instanceof COSStream) {
            return "--COSStream--";
        }
        if (value instanceof COSDictionary) {
            return "--COSDictionary--";
        }
        return null;
    }

    public List<InteractiveFormFieldFeaturesObjectAdapter> getChildren() {
        List childFormFields;
        if (this.formField instanceof PDNonTerminalField && (childFormFields = ((PDNonTerminalField)this.formField).getChildren()) != null && !childFormFields.isEmpty()) {
            ArrayList<PBInteractiveFormFieldFeaturesObjectAdapter> res = new ArrayList<PBInteractiveFormFieldFeaturesObjectAdapter>();
            for (PDField field : childFormFields) {
                res.add(new PBInteractiveFormFieldFeaturesObjectAdapter(field));
            }
        }
        return Collections.emptyList();
    }

    public boolean isPDFObjectPresent() {
        return this.formField != null;
    }

    public List<String> getErrors() {
        return Collections.emptyList();
    }
}

