/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.selayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDStructElem;
import org.verapdf.model.coslayer.CosLang;

		
/**  a content item such as text, image, lineart, shading or a form
 */
public interface SEContentItem extends Object {
	

	/**  suspected semantic role of this content item (such as Span, Figure, Heading, etc)
	 */
	public String getsuspectRole();


	/**  ampersand separated list of tags, associated with parents marked content sequences (first operand of the BMC/BDC operators)
	 */
	public String getparentsTags();

	/**  null, if it is not a part of the structure tree
	 */
	public String getparentStructureTag();

	/**  (if it is a part of the structure tree), null, if it is not a part of the structure tree
	 */
	public String getparentStandardTag();
}
