/**
 * This file is part of veraPDF Parser, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Parser is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Parser as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Parser as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.parser;

public enum PDFFlavour {
	NO_FLAVOUR(Specification.NO_STANDARD),
	PDFA_1_A(Specification.ISO_19005_1),
	PDFA_1_B(Specification.ISO_19005_1),
	PDFA_2_A(Specification.ISO_19005_2),
	PDFA_2_B(Specification.ISO_19005_2),
	PDFA_2_U(Specification.ISO_19005_2),
	PDFA_3_A(Specification.ISO_19005_3),
	PDFA_3_B(Specification.ISO_19005_3),
	PDFA_3_U(Specification.ISO_19005_3),
	PDFA_4(Specification.ISO_19005_4),
	PDFA_4_F(Specification.ISO_19005_4),
	PDFA_4_E(Specification.ISO_19005_4),
	PDFUA_1(Specification.ISO_14289_1),
	PDFUA_2(Specification.ISO_14289_2),
	WCAG2_1(Specification.WCAG2_1),
	WCAG2_2(Specification.WCAG2_2);

	private final Specification specification;

	private PDFFlavour(final Specification specification) {
		this.specification = specification;
	}

	public Specification getSpecification() {
		return specification;
	}

	public enum Specification {
		NO_STANDARD(SpecificationFamily.NONE),
		ISO_14289_1(SpecificationFamily.PDF_UA),
		ISO_14289_2(SpecificationFamily.PDF_UA),
		ISO_19005_1(SpecificationFamily.PDF_A),
		ISO_19005_2(SpecificationFamily.PDF_A),
		ISO_19005_3(SpecificationFamily.PDF_A),
		ISO_19005_4(SpecificationFamily.PDF_A),
		WCAG2_1(SpecificationFamily.WCAG),
		WCAG2_2(SpecificationFamily.WCAG);

		private final SpecificationFamily family;

		Specification(final SpecificationFamily family) {
			this.family = family;
		}
		
		public SpecificationFamily getFamily() {
			return family;
		}
	}
	
	public enum SpecificationFamily {
		NONE,
		PDF_A,
		PDF_UA,
		WCAG
	}
}
