/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos;

import java.util.Collection;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSIndirect;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSReal;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.COSString;
import org.verapdf.cos.visitor.IVisitor;

public class COSObject {
    private static final COSObject EMPTY = new COSObject();
    private COSBase base;
    private boolean isHeaderOfObjectComplyPDFA = true;
    private boolean isEndOfObjectComplyPDFA = true;
    private boolean isHeaderFormatComplyPDFA = true;

    public COSObject() {
    }

    public COSObject(COSBase base) {
        this.set(base);
    }

    public COSObject(COSObject object) {
        this.set(object.base);
    }

    public COSBase get() {
        return this.base;
    }

    public void set(COSBase base) {
        if (this.base == base) {
            return;
        }
        this.base = base;
    }

    public void assign(COSObject object) {
        if (object == null || object.get() == null) {
            return;
        }
        if (this.base != object.get()) {
            this.set(object.get());
        }
    }

    public boolean empty() {
        return this.base == null;
    }

    public void clear() {
        this.set(null);
    }

    public COSKey getObjectKey() {
        return this.base != null ? this.base.getObjectKey() : null;
    }

    public void setObjectKey(COSKey key) {
        if (this.base != null) {
            this.base.setObjectKey(key);
        }
    }

    public COSObjType getType() {
        return this.base != null ? this.base.getType() : COSObjType.COS_UNDEFINED;
    }

    public void accept(IVisitor visitor) {
        if (this.base != null) {
            this.base.accept(visitor);
        }
    }

    public Boolean getBoolean() {
        return this.base != null ? this.base.getBoolean() : null;
    }

    public void setBoolean(boolean value) {
        if (this.base == null || !this.base.setBoolean(value)) {
            this.base = new COSBoolean(value);
        }
    }

    public Long getInteger() {
        return this.base != null ? this.base.getInteger() : null;
    }

    public void setInteger(long value) {
        if (this.base == null || !this.base.setInteger(value)) {
            this.base = new COSInteger(value);
        }
    }

    public Double getReal() {
        return this.base != null ? this.base.getReal() : null;
    }

    public void setReal(double value) {
        if (this.base == null || !this.base.setReal(value)) {
            this.base = new COSReal(value);
        }
    }

    public String getString() {
        return this.base != null ? this.base.getString() : null;
    }

    public void setString(String value) {
        if (value != null) {
            this.setString(value, false);
        }
    }

    public void setString(String value, boolean isHex) {
        if (this.base == null || !this.base.setString(value, isHex)) {
            this.base = new COSString();
            this.base.setString(value);
        }
    }

    public ASAtom getName() {
        return this.base != null ? this.base.getName() : null;
    }

    public void setName(ASAtom value) {
        if (this.base == null || !this.base.setName(value)) {
            this.base = new COSName(value);
        }
    }

    public Integer size() {
        return this.base != null ? this.base.size() : null;
    }

    public COSObject at(int i) {
        return this.base != null ? this.base.at(i) : this;
    }

    public void add(COSObject value) {
        if (this.base == null || !this.base.add(value)) {
            this.base = new COSArray(1, value);
        }
    }

    public void set(int i, COSObject value) {
        if (this.base == null || !this.base.set(i, value)) {
            this.base = new COSArray(i, value);
        }
    }

    public void insert(int i, COSObject value) {
        if (this.base == null || !this.base.insert(i, value)) {
            this.base = new COSArray(i, value);
        }
    }

    public void remove(int i) {
        if (this.base != null) {
            this.base.remove(i);
        }
    }

    public void setArray() {
        if (this.base == null || !this.base.setArray()) {
            this.base = new COSArray();
        }
    }

    public void setArray(int size, COSObject[] value) {
        if (!(value == null || this.base != null && this.base.setArray(size, value))) {
            this.base = new COSArray(size, value);
        }
    }

    public void setArray(int size, double[] value) {
        if (!(value == null || this.base != null && this.base.setArray(size, value))) {
            this.base = new COSArray(size, value);
        }
    }

    public void clearArray() {
        if (this.base != null) {
            this.base.clearArray();
        }
    }

    public Boolean knownKey(ASAtom key) {
        return this.base != null ? this.base.knownKey(key) : null;
    }

    public COSObject getKey(ASAtom key) {
        return this.base != null ? this.base.getKey(key) : null;
    }

    public void setKey(ASAtom key, COSObject value) {
        if (!(value == null || this.base != null && this.base.setKey(key, value))) {
            this.base = new COSDictionary(key, value);
        }
    }

    public Boolean getBooleanKey(ASAtom key) {
        return this.base != null ? this.base.getBooleanKey(key) : null;
    }

    public void setBooleanKey(ASAtom key, boolean value) {
        if (this.base == null || !this.base.setBooleanKey(key, value)) {
            this.base = new COSDictionary(key, value);
        }
    }

    public Long getIntegerKey(ASAtom key) {
        return this.base != null ? this.base.getIntegerKey(key) : null;
    }

    public void setIntegerKey(ASAtom key, long value) {
        if (this.base == null || !this.base.setIntegerKey(key, value)) {
            this.base = new COSDictionary(key, value);
        }
    }

    public Double getRealKey(ASAtom key) {
        return this.base != null ? this.base.getRealKey(key) : null;
    }

    public void setRealKey(ASAtom key, double value) {
        if (this.base == null || !this.base.setRealKey(key, value)) {
            this.base = new COSDictionary(key, value);
        }
    }

    public String getStringKey(ASAtom key) {
        return this.base != null ? this.base.getStringKey(key) : null;
    }

    public void setStringKey(ASAtom key, String value) {
        if (!(value == null || this.base != null && this.base.setStringKey(key, value))) {
            this.base = new COSDictionary(key, value);
        }
    }

    public ASAtom getNameKey(ASAtom key) {
        return this.base != null ? this.base.getNameKey(key) : null;
    }

    public void setNameKey(ASAtom key, ASAtom value) {
        if (!(value == null || this.base != null && this.base.setNameKey(key, value))) {
            this.base = new COSDictionary(key, value);
        }
    }

    public void setArrayKey(ASAtom key) {
        if (this.base == null || !this.base.setArrayKey(key)) {
            COSObject obj = COSArray.construct();
            this.base = new COSDictionary(key, obj);
        }
    }

    public void setArrayKey(ASAtom key, COSObject array) {
        if (!(array == null || this.base != null && this.base.setArrayKey(key, array))) {
            COSObject obj = COSArray.construct();
            this.base = new COSDictionary(key, obj);
        }
    }

    public void setArrayKey(ASAtom key, int size, COSObject[] value) {
        if (!(value == null || this.base != null && this.base.setArrayKey(key, size, value))) {
            COSObject obj = COSArray.construct(size, value);
            this.base = new COSDictionary(key, obj);
        }
    }

    public void setArrayKey(ASAtom key, int size, double[] value) {
        if (value != null && (this.base == null || this.base.setArrayKey(key, size, value))) {
            COSObject obj = COSArray.construct(size, value);
            this.base = new COSDictionary(key, obj);
        }
    }

    public void removeKey(ASAtom key) {
        if (this.base != null) {
            this.base.removeKey(key);
        }
    }

    public Set<ASAtom> getKeySet() {
        if (this.base != null) {
            return this.base.getKeySet();
        }
        return null;
    }

    public Collection<COSObject> getValues() {
        if (this.base != null) {
            return this.base.getValues();
        }
        return null;
    }

    public ASInputStream getData() {
        return this.getData(COSStream.FilterFlags.RAW_DATA);
    }

    public ASInputStream getData(COSStream.FilterFlags flags) {
        return this.base != null ? this.base.getData(flags) : null;
    }

    public void setData(ASInputStream stream) {
        if (stream != null) {
            this.setData(stream, COSStream.FilterFlags.RAW_DATA);
        }
    }

    public void setData(ASInputStream stream, COSStream.FilterFlags flags) {
        if (!(stream == null || this.base != null && this.base.setData(stream, flags))) {
            COSObject obj = this.base instanceof COSDictionary ? COSStream.construct((COSDictionary)this.base, stream, flags) : COSStream.construct(stream);
            this.base = obj.base;
        }
    }

    public Boolean isStreamKeywordCRLFCompliant() {
        return this.base != null ? this.base.isStreamKeywordCRLFCompliant() : null;
    }

    public void setStreamKeywordCRLFCompliant(boolean streamKeywordCRLFCompliant) {
        if (this.base == null || !this.base.setStreamKeywordCRLFCompliant(streamKeywordCRLFCompliant)) {
            COSObject obj = this.base instanceof COSDictionary ? COSStream.construct((COSDictionary)this.base) : COSStream.construct();
            this.base = obj.base;
            this.base.setStreamKeywordCRLFCompliant(streamKeywordCRLFCompliant);
        }
    }

    public Boolean isEndstreamKeywordCRLFCompliant() {
        return this.base != null ? this.base.isEndstreamKeywordCRLFCompliant() : null;
    }

    public void setEndstreamKeywordCRLFCompliant(boolean endstreamKeywordCRLFCompliant) {
        if (this.base == null || !this.base.setEndstreamKeywordCRLFCompliant(endstreamKeywordCRLFCompliant)) {
            COSObject obj = this.base instanceof COSDictionary ? COSStream.construct((COSDictionary)this.base) : COSStream.construct();
            this.base = obj.base;
            this.base.setEndstreamKeywordCRLFCompliant(endstreamKeywordCRLFCompliant);
        }
    }

    public Long getRealStreamSize() {
        return this.base != null ? this.base.getRealStreamSize() : null;
    }

    public void setRealStreamSize(long realStreamSize) {
        if (this.base == null || !this.base.setRealStreamSize(realStreamSize)) {
            COSObject obj = this.base instanceof COSDictionary ? COSStream.construct((COSDictionary)this.base) : COSStream.construct();
            this.base = obj.base;
            this.base.setRealStreamSize(realStreamSize);
        }
    }

    public Boolean isIndirect() {
        return this.base != null ? this.base.isIndirect() : null;
    }

    public COSKey getKey() {
        return this.base != null ? this.base.getKey() : null;
    }

    public COSDocument getDocument() {
        return this.base != null ? this.base.getDocument() : null;
    }

    public void setKey(COSKey key, COSDocument document) {
        if (this.base == null || this.base.setKey(key, document)) {
            this.base = new COSIndirect(key, document);
        }
    }

    public COSObject getDirect() {
        return this.base != null ? this.base.getDirect() : null;
    }

    public COSBase getDirectBase() {
        return this.base != null ? this.base.getDirectBase() : null;
    }

    public void setDirect(COSObject value) {
        if (!(value == null || this.base != null && this.base.setDirect(value))) {
            this.set(value.base);
        }
    }

    public void mark() {
        if (this.base != null) {
            this.base.mark();
        }
    }

    public static COSObject getEmpty() {
        return EMPTY;
    }

    public Boolean isHeaderOfObjectComplyPDFA() {
        return this.isHeaderOfObjectComplyPDFA;
    }

    public void setIsHeaderOfObjectComplyPDFA(Boolean isHeaderOfObjectComplyPDFA) {
        this.isHeaderOfObjectComplyPDFA = isHeaderOfObjectComplyPDFA;
    }

    public Boolean isEndOfObjectComplyPDFA() {
        return this.isEndOfObjectComplyPDFA;
    }

    public void setIsEndOfObjectComplyPDFA(Boolean isEndOfObjectComplyPDFA) {
        this.isEndOfObjectComplyPDFA = isEndOfObjectComplyPDFA;
    }

    public Boolean isHeaderFormatComplyPDFA() {
        return this.isHeaderFormatComplyPDFA;
    }

    public void setIsHeaderFormatComplyPDFA(Boolean isHeaderFormatComplyPDFA) {
        this.isHeaderFormatComplyPDFA = isHeaderFormatComplyPDFA;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof COSObject)) {
            return false;
        }
        COSObject cosObject = (COSObject)o;
        return this.base != null ? this.base.equals(cosObject.base) : cosObject.base == null;
    }

    public String toString() {
        return this.base != null ? this.base.toString() : null;
    }
}

