/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.validators;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.pdfa.validation.profiles.ErrorArgument;
import org.verapdf.pdfa.validation.profiles.ErrorArgumentImpl;
import org.verapdf.pdfa.validation.profiles.Rule;
import org.verapdf.pdfa.validation.profiles.Variable;

public class JavaScriptEvaluator {
    private static final int OPTIMIZATION_LEVEL = 9;
    private static final ThreadLocal<Context> context = new ThreadLocal();
    private static final ThreadLocal<Map<String, Script>> ruleScripts = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<Map<String, Script>> variableScripts = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<Map<String, Script>> argumentScripts = ThreadLocal.withInitial(HashMap::new);

    public static ScriptableObject initialise() {
        Context newContext = Context.enter();
        context.set(newContext);
        newContext.setOptimizationLevel(9);
        return newContext.initStandardObjects();
    }

    public static java.lang.Object evaluateString(String source, ScriptableObject scope) {
        return context.get().evaluateString((Scriptable)scope, source, null, 0, null);
    }

    public static java.lang.Object evalVariableResult(Variable variable, Object object, ScriptableObject scope) {
        Script script;
        if (!variableScripts.get().containsKey(variable.getName())) {
            String source = JavaScriptEvaluator.getStringScript(object, variable.getValue());
            script = JavaScriptEvaluator.compileString(source);
            variableScripts.get().put(variable.getName(), script);
        } else {
            script = variableScripts.get().get(variable.getName());
        }
        scope.put("obj", (Scriptable)scope, (java.lang.Object)object);
        java.lang.Object res = script.exec(context.get(), (Scriptable)scope);
        if (res instanceof NativeJavaObject) {
            res = ((NativeJavaObject)res).unwrap();
        }
        return res;
    }

    private static Script compileString(String source) {
        return context.get().compileString(source, null, 0, null);
    }

    private static String getStringScript(Object obj, String arg) {
        return JavaScriptEvaluator.getScriptPrefix(obj, arg) + arg + JavaScriptEvaluator.getScriptSuffix();
    }

    private static String getScriptPrefix(Object obj, String test) {
        StringBuilder builder = new StringBuilder();
        String[] vars = test.split("\\W");
        for (String prop : obj.getProperties()) {
            if (!JavaScriptEvaluator.contains(vars, prop)) continue;
            builder.append("var ");
            builder.append(prop);
            builder.append(" = obj.get");
            builder.append(prop);
            builder.append("();\n");
        }
        for (String linkName : obj.getLinks()) {
            if (!JavaScriptEvaluator.contains(vars, linkName + "_size")) continue;
            builder.append("var ");
            builder.append(linkName);
            builder.append("_size = obj.getLinkedObjects(\"");
            builder.append(linkName);
            builder.append("\").size();\n");
        }
        builder.append("function test(){return ");
        return builder.toString();
    }

    private static boolean contains(String[] values, String prop) {
        for (String value : values) {
            if (!value.equals(prop)) continue;
            return true;
        }
        return false;
    }

    private static String getScriptSuffix() {
        return ";}\ntest();";
    }

    private static String getScript(Object obj, String test) {
        return JavaScriptEvaluator.getStringScript(obj, "(" + test + ")==true");
    }

    public static boolean getTestEvalResult(Object obj, Rule rule, ScriptableObject scope) {
        Script scr;
        scope.put("obj", (Scriptable)scope, (java.lang.Object)obj);
        String test = rule.getTest();
        if (!ruleScripts.get().containsKey(test)) {
            scr = JavaScriptEvaluator.compileString(JavaScriptEvaluator.getScript(obj, test));
            ruleScripts.get().put(test, scr);
        } else {
            scr = ruleScripts.get().get(test);
        }
        boolean testEvalResult = (Boolean)scr.exec(context.get(), (Scriptable)scope);
        return testEvalResult;
    }

    private static String getErrorArgumentResult(String argument, Object obj, ScriptableObject scope) {
        String resultString;
        Script scr;
        if (!argumentScripts.get().containsKey(argument)) {
            scr = JavaScriptEvaluator.compileString(JavaScriptEvaluator.getStringScript(obj, argument));
            argumentScripts.get().put(argument, scr);
        } else {
            scr = argumentScripts.get().get(argument);
        }
        java.lang.Object res = scr.exec(context.get(), (Scriptable)scope);
        if (res instanceof NativeJavaObject) {
            res = ((NativeJavaObject)res).unwrap();
        }
        if (res instanceof Double && Math.abs((Double)res - Math.floor((Double)res)) < 1.0E-7) {
            return Integer.toString(((Double)res).intValue());
        }
        if (res instanceof String && ((resultString = res.toString()).isEmpty() || "null".equals(resultString))) {
            return "\"" + resultString + "\"";
        }
        return res != null ? res.toString() : null;
    }

    public static List<ErrorArgument> getErrorArgumentsResult(Object obj, List<ErrorArgument> arguments, ScriptableObject scope) {
        LinkedList<ErrorArgument> result = new LinkedList<ErrorArgument>();
        for (ErrorArgument argument : arguments) {
            result.add(ErrorArgumentImpl.fromValues(argument.getArgument(), argument.getName(), JavaScriptEvaluator.getErrorArgumentResult(argument.getArgument(), obj, scope)));
        }
        return result;
    }

    public static void exitContext() {
        Context.exit();
    }
}

