/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports;

import java.util.List;
import javax.xml.bind.JAXBException;
import org.verapdf.component.Components;
import org.verapdf.core.XmlSerialiser;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.processor.reports.BatchSummaryImpl;
import org.verapdf.processor.reports.FeaturesBatchSummary;
import org.verapdf.processor.reports.FixerReportImpl;
import org.verapdf.processor.reports.MetadataFixerReport;
import org.verapdf.processor.reports.MetadataRepairBatchSummary;
import org.verapdf.processor.reports.ValidationBatchSummary;
import org.verapdf.processor.reports.ValidationDetails;
import org.verapdf.processor.reports.ValidationDetailsImpl;
import org.verapdf.processor.reports.ValidationReport;
import org.verapdf.processor.reports.ValidationReportImpl;

public final class Reports {
    private Reports() {
        throw new AssertionError((Object)"Should never enter Reports().");
    }

    public static final BatchSummary createBatchSummary(Components.Timer timer, ValidationBatchSummary validationSummary, FeaturesBatchSummary featureSummary, MetadataRepairBatchSummary repairSummary, int totalJobs, int failedToParse, int encrypted) {
        if (totalJobs < 0) {
            throw new IllegalArgumentException("Argument totalJobs must be >= 0");
        }
        if (failedToParse < 0) {
            throw new IllegalArgumentException("Argument failedToParse must be >= 0");
        }
        if (encrypted < 0) {
            throw new IllegalArgumentException("Argument encrypted must be >= 0");
        }
        if (failedToParse + encrypted > totalJobs) {
            throw new IllegalArgumentException("Argument totalJobs must be >= arguments (failedJobs + encrypted)");
        }
        return BatchSummaryImpl.fromValues(timer.stop(), validationSummary, featureSummary, repairSummary, totalJobs, failedToParse, encrypted);
    }

    public static final ValidationReport createValidationReport(ValidationDetails details, String profileName, String statement, boolean isCompliant) {
        return ValidationReportImpl.fromValues(details, profileName, statement, isCompliant);
    }

    public static final ValidationReport validationReportFromXml(String xmlSource) throws JAXBException {
        return (ValidationReport)XmlSerialiser.typeFromXml(ValidationReportImpl.class, xmlSource);
    }

    public static final ValidationDetails fromValues(ValidationResult result, boolean logPassedChecks, int maxFailedChecks) {
        return ValidationDetailsImpl.fromValues(result, logPassedChecks, maxFailedChecks);
    }

    public static final MetadataFixerReport fromValues(String status, int fixCount, List<String> fixes, List<String> errors) {
        return FixerReportImpl.fromValues(status, fixCount, fixes, errors);
    }

    public static final MetadataFixerReport fromValues(MetadataFixerResult fixerResult) {
        return FixerReportImpl.fromValues(fixerResult);
    }
}

