/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.core.VeraPDFException;
import org.verapdf.processor.AbstractBatchProcessor;
import org.verapdf.processor.ItemProcessor;
import org.verapdf.processor.ProcessorResult;

public final class BatchFileProcessor
extends AbstractBatchProcessor {
    private static final Logger logger = Logger.getLogger(BatchFileProcessor.class.getCanonicalName());

    public BatchFileProcessor(ItemProcessor processor) {
        super(processor);
    }

    @Override
    protected void processContainer(File container, boolean recurse) throws VeraPDFException {
        if (container == null || !container.isDirectory() || !container.canRead()) {
            logger.log(Level.SEVERE, BatchFileProcessor.badItemMessage(container, true));
        } else {
            this.processDir(container, recurse);
        }
    }

    @Override
    protected void processList(List<? extends File> toProcess) throws VeraPDFException {
        for (File file : toProcess) {
            if (file == null || !file.isFile() || !file.canRead()) {
                logger.log(Level.SEVERE, BatchFileProcessor.badItemMessage(file, false));
                continue;
            }
            this.processItem(file);
        }
    }

    private void processDir(File toProcess, boolean recurse) throws VeraPDFException {
        for (File item : toProcess.listFiles()) {
            if (item.isHidden() || !item.canRead()) continue;
            if (item.isDirectory()) {
                this.processDir(item, recurse);
                continue;
            }
            if (!item.isFile() || !BatchFileProcessor.isPdf(item.getName())) continue;
            this.processItem(item);
        }
    }

    private static boolean isPdf(String name) {
        if (!name.endsWith(".pdf")) {
            return name.endsWith(".PDF");
        }
        return true;
    }

    private void processItem(File item) throws VeraPDFException {
        if (this.processor.getConfig().getValidatorConfig().isDebug()) {
            logger.log(Level.WARNING, item.getAbsolutePath());
        }
        ProcessorResult result = this.processor.process(item);
        this.processResult(result);
    }

    private static String badItemMessage(File item, boolean isDir) {
        String itemType;
        String string = itemType = isDir ? "directory" : "file";
        if (item == null) {
            return "Null " + itemType + " item passed for processing.";
        }
        String rootMessage = "Couldn't process: " + item.getAbsolutePath() + " is not a ";
        String messageTrail = item.canRead() ? itemType + "." : "readable " + itemType + ".";
        return rootMessage + messageTrail;
    }
}

