/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.validators;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.verapdf.component.ComponentDetails;
import org.verapdf.component.Components;
import org.verapdf.core.ModelParsingException;
import org.verapdf.core.ValidationException;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.results.Location;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.results.ValidationResults;
import org.verapdf.pdfa.validation.profiles.Rule;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.profiles.Variable;
import org.verapdf.pdfa.validation.validators.JavaScriptEvaluator;

class BaseValidator
implements PDFAValidator {
    private static final URI componentId = URI.create("http://pdfa.verapdf.org/validators#default");
    private static final String componentName = "veraPDF PDF/A Validator";
    private static final ComponentDetails componentDetails = Components.libraryDetails(componentId, "veraPDF PDF/A Validator");
    private final ValidationProfile profile;
    private ScriptableObject scope;
    private final Deque<org.verapdf.model.baselayer.Object> objectsStack = new ArrayDeque<org.verapdf.model.baselayer.Object>();
    private final Deque<String> objectsContext = new ArrayDeque<String>();
    private final Map<Rule, List<ObjectWithContext>> deferredRules = new HashMap<Rule, List<ObjectWithContext>>();
    protected final List<TestAssertion> results = new ArrayList<TestAssertion>();
    protected int testCounter = 0;
    protected boolean abortProcessing = false;
    protected final boolean logPassedTests;
    protected boolean isCompliant = true;
    private Set<String> idSet = new HashSet<String>();
    protected String rootType;

    protected BaseValidator(ValidationProfile profile) {
        this(profile, false);
    }

    protected BaseValidator(ValidationProfile profile, boolean logPassedTests) {
        this.profile = profile;
        this.logPassedTests = logPassedTests;
    }

    @Override
    public ValidationProfile getProfile() {
        return this.profile;
    }

    @Override
    public ValidationResult validate(PDFAParser toValidate) throws ValidationException {
        try {
            return this.validate(toValidate.getRoot());
        }
        catch (RuntimeException e) {
            throw new ValidationException("Caught unexpected runtime exception during validation", e);
        }
        catch (ModelParsingException excep) {
            throw new ValidationException("Parsing problem trying to validate.", excep);
        }
    }

    @Override
    public ComponentDetails getDetails() {
        return componentDetails;
    }

    protected ValidationResult validate(org.verapdf.model.baselayer.Object root) throws ValidationException {
        this.initialise();
        this.rootType = root.getObjectType();
        this.objectsStack.push(root);
        this.objectsContext.push("root");
        if (root.getID() != null) {
            this.idSet.add(root.getID());
        }
        while (!this.objectsStack.isEmpty() && !this.abortProcessing) {
            this.checkNext();
        }
        for (Map.Entry<Rule, List<ObjectWithContext>> entry : this.deferredRules.entrySet()) {
            for (ObjectWithContext objectWithContext : entry.getValue()) {
                this.checkObjWithRule(objectWithContext.getObject(), objectWithContext.getContext(), entry.getKey());
            }
        }
        JavaScriptEvaluator.exitContext();
        return ValidationResults.resultFromValues(this.profile, this.results, this.isCompliant, this.testCounter);
    }

    protected void initialise() {
        this.scope = JavaScriptEvaluator.initialise();
        this.objectsStack.clear();
        this.objectsContext.clear();
        this.deferredRules.clear();
        this.results.clear();
        this.idSet.clear();
        this.testCounter = 0;
        this.isCompliant = true;
        this.initializeAllVariables();
    }

    private void initializeAllVariables() {
        for (Variable var : this.profile.getVariables()) {
            if (var == null) continue;
            Object res = JavaScriptEvaluator.evaluateString(var.getDefaultValue(), this.scope);
            if (res instanceof NativeJavaObject) {
                res = ((NativeJavaObject)res).unwrap();
            }
            this.scope.put(var.getName(), (Scriptable)this.scope, res);
        }
    }

    private void checkNext() throws ValidationException {
        org.verapdf.model.baselayer.Object checkObject = this.objectsStack.pop();
        String checkContext = this.objectsContext.pop();
        this.checkAllRules(checkObject, checkContext);
        this.updateVariables(checkObject);
        this.addAllLinkedObjects(checkObject, checkContext);
    }

    private void updateVariables(org.verapdf.model.baselayer.Object object) {
        if (object != null) {
            this.updateVariableForObjectWithType(object, object.getObjectType());
            for (String parentName : object.getSuperTypes()) {
                this.updateVariableForObjectWithType(object, parentName);
            }
        }
    }

    private void updateVariableForObjectWithType(org.verapdf.model.baselayer.Object object, String objectType) {
        for (Variable var : this.profile.getVariablesByObject(objectType)) {
            if (var == null) continue;
            Object variable = JavaScriptEvaluator.evalVariableResult(var, object, this.scope);
            this.scope.put(var.getName(), (Scriptable)this.scope, variable);
        }
    }

    private void addAllLinkedObjects(org.verapdf.model.baselayer.Object checkObject, String checkContext) throws ValidationException {
        List links = checkObject.getLinks();
        for (int j = links.size() - 1; j >= 0; --j) {
            String link = (String)links.get(j);
            if (link == null) {
                throw new ValidationException("There is a null link name in an object. Context: " + checkContext);
            }
            List objects = checkObject.getLinkedObjects(link);
            if (objects == null) {
                throw new ValidationException("There is a null link in an object. Context: " + checkContext);
            }
            for (int i = objects.size() - 1; i >= 0; --i) {
                org.verapdf.model.baselayer.Object obj = (org.verapdf.model.baselayer.Object)objects.get(i);
                StringBuilder path = new StringBuilder(checkContext);
                path.append("/");
                path.append(link);
                path.append("[");
                path.append(i);
                path.append("]");
                if (obj == null) {
                    throw new ValidationException("There is a null link in an object. Context of the link: " + path);
                }
                if (!this.checkRequired(obj)) continue;
                this.objectsStack.push(obj);
                if (obj.getID() != null) {
                    path.append("(");
                    path.append(obj.getID());
                    path.append(")");
                    this.idSet.add(obj.getID());
                }
                if (obj.getExtraContext() != null) {
                    path.append("{");
                    path.append(obj.getExtraContext());
                    path.append("}");
                }
                this.objectsContext.push(path.toString());
            }
        }
    }

    private boolean checkRequired(org.verapdf.model.baselayer.Object obj) {
        return obj.getID() == null || !this.idSet.contains(obj.getID());
    }

    private boolean checkAllRules(org.verapdf.model.baselayer.Object checkObject, String checkContext) {
        boolean res = true;
        Set<Rule> roolsForObject = this.profile.getRulesByObject(checkObject.getObjectType());
        for (Rule rule : roolsForObject) {
            res &= this.firstProcessObjectWithRule(checkObject, checkContext, rule);
        }
        for (String checkType : checkObject.getSuperTypes()) {
            roolsForObject = this.profile.getRulesByObject(checkType);
            if (roolsForObject == null) continue;
            for (Rule rule : roolsForObject) {
                if (rule == null) continue;
                res &= this.firstProcessObjectWithRule(checkObject, checkContext, rule);
            }
        }
        return res;
    }

    private boolean firstProcessObjectWithRule(org.verapdf.model.baselayer.Object checkObject, String checkContext, Rule rule) {
        Boolean deferred = rule.getDeferred();
        if (deferred != null && deferred.booleanValue()) {
            List<ObjectWithContext> list = this.deferredRules.get(rule);
            if (list == null) {
                list = new ArrayList<ObjectWithContext>();
                this.deferredRules.put(rule, list);
            }
            list.add(new ObjectWithContext(checkObject, checkContext));
            return true;
        }
        return this.checkObjWithRule(checkObject, checkContext, rule);
    }

    private boolean checkObjWithRule(org.verapdf.model.baselayer.Object obj, String cntxtForRule, Rule rule) {
        boolean testEvalResult = JavaScriptEvaluator.getTestEvalResult(obj, rule, this.scope);
        this.processAssertionResult(testEvalResult, cntxtForRule, rule, obj);
        return testEvalResult;
    }

    protected void processAssertionResult(boolean assertionResult, String locationContext, Rule rule, org.verapdf.model.baselayer.Object obj) {
        if (!this.abortProcessing) {
            ++this.testCounter;
            if (this.isCompliant) {
                this.isCompliant = assertionResult;
            }
            if (!assertionResult || this.logPassedTests) {
                Location location;
                String errorMessage = "";
                ArrayList<String> errorArguments = new ArrayList();
                if (this.results.size() > 10000) {
                    location = ValidationResults.locationFromValues(this.rootType, "");
                } else {
                    location = ValidationResults.locationFromValues(this.rootType, locationContext);
                    errorArguments = JavaScriptEvaluator.getErrorArgumentsResult(obj, rule.getError().getArguments(), this.scope);
                    errorMessage = this.createErrorMessage(rule.getError().getMessage(), errorArguments);
                }
                TestAssertion assertion = ValidationResults.assertionFromValues(this.testCounter, rule.getRuleId(), assertionResult ? TestAssertion.Status.PASSED : TestAssertion.Status.FAILED, rule.getDescription(), location, obj.getContext(), errorMessage, errorArguments);
                this.results.add(assertion);
            }
        }
    }

    private String createErrorMessage(String errorMessage, List<String> arguments) {
        for (int i = arguments.size(); i > 0; --i) {
            errorMessage = errorMessage.replace("%" + i, arguments.get(i - 1) != null ? (CharSequence)arguments.get(i - 1) : "null");
        }
        return errorMessage;
    }

    @Override
    public void close() {
    }

    private static class ObjectWithContext {
        private final org.verapdf.model.baselayer.Object object;
        private final String context;

        public ObjectWithContext(org.verapdf.model.baselayer.Object object, String context) {
            this.object = object;
            this.context = context;
        }

        public org.verapdf.model.baselayer.Object getObject() {
            return this.object;
        }

        public String getContext() {
            return this.context;
        }
    }
}

