/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.axl;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.VeraPDFMeta;
import com.adobe.xmp.impl.VeraPDFXMPNode;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.model.impl.axl.AXLXMPObject;
import org.verapdf.model.xmplayer.PDFAIdentification;

public class AXLPDFAIdentification
extends AXLXMPObject
implements PDFAIdentification {
    private static final Logger LOGGER = Logger.getLogger(AXLPDFAIdentification.class.getName());
    public static final String PDFA_IDENTIFICATION = "PDFAIdentification";
    private final VeraPDFMeta metadata;

    public AXLPDFAIdentification(VeraPDFMeta metadata) {
        super(PDFA_IDENTIFICATION);
        this.metadata = metadata;
    }

    public Long getpart() {
        try {
            Integer part = this.metadata.getIdentificationPart();
            return part == null ? null : Long.valueOf(part.longValue());
        }
        catch (XMPException e) {
            LOGGER.log(Level.FINE, "Can not get identification part", e);
            return null;
        }
    }

    public String getconformance() {
        try {
            return this.metadata.getIdentificationConformance();
        }
        catch (XMPException e) {
            LOGGER.log(Level.FINE, "Can not get identification conformance", e);
            return null;
        }
    }

    public String getpartPrefix() {
        VeraPDFXMPNode property = this.metadata.getProperty("http://www.aiim.org/pdfa/ns/id/", "part");
        return property == null ? null : property.getPrefix();
    }

    public String getconformancePrefix() {
        VeraPDFXMPNode property = this.metadata.getProperty("http://www.aiim.org/pdfa/ns/id/", "conformance");
        return property == null ? null : property.getPrefix();
    }

    public String getamdPrefix() {
        VeraPDFXMPNode property = this.metadata.getProperty("http://www.aiim.org/pdfa/ns/id/", "amd");
        return property == null ? null : property.getPrefix();
    }

    public String getcorrPrefix() {
        VeraPDFXMPNode property = this.metadata.getProperty("http://www.aiim.org/pdfa/ns/id/", "corr");
        return property == null ? null : property.getPrefix();
    }

    public String getrevPrefix() {
        VeraPDFXMPNode property = this.metadata.getProperty("http://www.aiim.org/pdfa/ns/id/", "rev");
        return property == null ? null : property.getPrefix();
    }

    public String getrev() {
        try {
            return this.metadata.getRevisionYear();
        }
        catch (XMPException e) {
            LOGGER.log(Level.FINE, "Can not get revision year", e);
            return null;
        }
    }
}

