/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.ICCProfileFeaturesData;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.objects.ICCProfileFeaturesObjectAdapter;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class ICCProfileFeaturesObject
extends FeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(ICCProfileFeaturesObject.class.getCanonicalName());
    private static final String ID = "id";
    private static final String ICCPROFILE = "iccProfile";
    private static final String VERSION = "version";
    private static final String CMM_TYPE = "cmmType";
    private static final String DATA_COLOR_SPACE = "dataColorSpace";
    private static final String CREATOR = "creator";
    private static final String CREATION_DATE = "creationDate";
    private static final String DEFAULT_RENDERING_INTENT = "defaultRenderingIntent";
    private static final String COPYRIGHT = "copyright";
    private static final String DESCRIPTION = "description";
    private static final String PROFILE_ID = "profileId";
    private static final String DEVICE_MODEL = "deviceModel";
    private static final String DEVICE_MANUFACTURER = "deviceManufacturer";

    public ICCProfileFeaturesObject(ICCProfileFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.ICCPROFILE;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        ICCProfileFeaturesObjectAdapter ipAdapter = (ICCProfileFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(ICCPROFILE);
        String id = ipAdapter.getId();
        if (id != null) {
            root.setAttribute(ID, id);
        }
        this.parseProfileHeader(root);
        try (InputStream is = ipAdapter.getMetadataStream();){
            CreateNodeHelper.parseMetadata(is, "metadata", root, this);
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Error while obtaining unfiltered metadata stream", e);
            this.registerNewError(e.getMessage());
        }
        return root;
    }

    private void parseProfileHeader(FeatureTreeNode root) throws FeatureParsingException {
        ICCProfileFeaturesObjectAdapter ipAdapter = (ICCProfileFeaturesObjectAdapter)this.adapter;
        CreateNodeHelper.addNotEmptyNode(VERSION, ipAdapter.getVersion(), root);
        CreateNodeHelper.addNotEmptyNode(CMM_TYPE, ipAdapter.getCMMType(), root);
        CreateNodeHelper.addNotEmptyNode(DATA_COLOR_SPACE, ipAdapter.getDataColorSpace(), root);
        CreateNodeHelper.addNotEmptyNode(CREATOR, ipAdapter.getCreator(), root);
        CreateNodeHelper.createDateNode(CREATION_DATE, root, ipAdapter.getCreationDate(), this);
        CreateNodeHelper.addNotEmptyNode(DEFAULT_RENDERING_INTENT, ipAdapter.getDefaultRenderingIntent(), root);
        CreateNodeHelper.addNotEmptyNode(COPYRIGHT, ipAdapter.getCopyright(), root);
        CreateNodeHelper.addNotEmptyNode(DESCRIPTION, ipAdapter.getDescription(), root);
        CreateNodeHelper.addNotEmptyNode(PROFILE_ID, ipAdapter.getProfileID(), root);
        CreateNodeHelper.addNotEmptyNode(DEVICE_MODEL, ipAdapter.getDeviceModel(), root);
        CreateNodeHelper.addNotEmptyNode(DEVICE_MANUFACTURER, ipAdapter.getDeviceManufacturer(), root);
    }

    @Override
    public FeaturesData getData() {
        ICCProfileFeaturesObjectAdapter ipAdapter = (ICCProfileFeaturesObjectAdapter)this.adapter;
        InputStream stream = ipAdapter.getData();
        if (stream == null) {
            LOGGER.log(Level.FINE, "Missed icc profile InputStream");
            return null;
        }
        InputStream metadata = ipAdapter.getMetadataStream();
        Integer n = ipAdapter.getN();
        List<Double> range = ipAdapter.getRange();
        return ICCProfileFeaturesData.newInstance(metadata, stream, n, range);
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Version", ICCProfileFeaturesObject.generateVariableXPath(ICCPROFILE, VERSION), Feature.FeatureType.STRING));
        featuresList.add(new Feature("CMM Type", ICCProfileFeaturesObject.generateVariableXPath(ICCPROFILE, CMM_TYPE), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Data Color Space", ICCProfileFeaturesObject.generateVariableXPath(ICCPROFILE, DATA_COLOR_SPACE), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Creator", ICCProfileFeaturesObject.generateVariableXPath(ICCPROFILE, CREATOR), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Creation Date", ICCProfileFeaturesObject.generateVariableXPath(ICCPROFILE, CREATION_DATE), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Default Rendering Intent", ICCProfileFeaturesObject.generateVariableXPath(ICCPROFILE, DEFAULT_RENDERING_INTENT), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Copyright", ICCProfileFeaturesObject.generateVariableXPath(ICCPROFILE, COPYRIGHT), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Description", ICCProfileFeaturesObject.generateVariableXPath(ICCPROFILE, DESCRIPTION), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Profile ID", ICCProfileFeaturesObject.generateVariableXPath(ICCPROFILE, PROFILE_ID), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Device Model", ICCProfileFeaturesObject.generateVariableXPath(ICCPROFILE, DEVICE_MODEL), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Device Manufacturer", ICCProfileFeaturesObject.generateVariableXPath(ICCPROFILE, DEVICE_MANUFACTURER), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Error IDs", ICCProfileFeaturesObject.generateAttributeXPath(ICCPROFILE, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

