/*
 * Decompiled with CFR 0.152.
 */
package org.velvia.msgpack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import org.velvia.InvalidMsgPackDataException;
import org.velvia.msgpack.Codec;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class Format$ {
    public static final Format$ MODULE$;
    private final int MAX_4BIT;
    private final int MAX_5BIT;
    private final int MAX_7BIT;
    private final int MAX_8BIT;
    private final int MAX_15BIT;
    private final int MAX_16BIT;
    private final int MAX_31BIT;
    private final long MAX_32BIT;
    private final byte MP_NULL;
    private final byte MP_FALSE;
    private final byte MP_TRUE;
    private final byte MP_FLOAT;
    private final byte MP_DOUBLE;
    private final byte MP_FIXNUM;
    private final byte MP_UINT8;
    private final byte MP_UINT16;
    private final byte MP_UINT32;
    private final byte MP_UINT64;
    private final byte MP_NEGATIVE_FIXNUM;
    private final int MP_NEGATIVE_FIXNUM_INT;
    private final byte MP_INT8;
    private final byte MP_INT16;
    private final byte MP_INT32;
    private final byte MP_INT64;
    private final byte MP_FIXARRAY;
    private final int MP_FIXARRAY_INT;
    private final byte MP_ARRAY16;
    private final byte MP_ARRAY32;
    private final byte MP_FIXMAP;
    private final int MP_FIXMAP_INT;
    private final byte MP_MAP16;
    private final byte MP_MAP32;
    private final byte MP_FIXSTR;
    private final int MP_FIXSTR_INT;
    private final byte MP_STR8;
    private final byte MP_STR16;
    private final byte MP_STR32;
    private final byte MP_RAW8;
    private final byte MP_RAW16;
    private final byte MP_RAW32;
    private final int UNPACK_RAW_AS_STRING;
    private final int UNPACK_RAW_AS_BYTE_BUFFER;

    static {
        new Format$();
    }

    public int MAX_4BIT() {
        return this.MAX_4BIT;
    }

    public int MAX_5BIT() {
        return this.MAX_5BIT;
    }

    public int MAX_7BIT() {
        return this.MAX_7BIT;
    }

    public int MAX_8BIT() {
        return this.MAX_8BIT;
    }

    public int MAX_15BIT() {
        return this.MAX_15BIT;
    }

    public int MAX_16BIT() {
        return this.MAX_16BIT;
    }

    public int MAX_31BIT() {
        return this.MAX_31BIT;
    }

    public long MAX_32BIT() {
        return this.MAX_32BIT;
    }

    public byte MP_NULL() {
        return this.MP_NULL;
    }

    public byte MP_FALSE() {
        return this.MP_FALSE;
    }

    public byte MP_TRUE() {
        return this.MP_TRUE;
    }

    public byte MP_FLOAT() {
        return this.MP_FLOAT;
    }

    public byte MP_DOUBLE() {
        return this.MP_DOUBLE;
    }

    public byte MP_FIXNUM() {
        return this.MP_FIXNUM;
    }

    public byte MP_UINT8() {
        return this.MP_UINT8;
    }

    public byte MP_UINT16() {
        return this.MP_UINT16;
    }

    public byte MP_UINT32() {
        return this.MP_UINT32;
    }

    public byte MP_UINT64() {
        return this.MP_UINT64;
    }

    public byte MP_NEGATIVE_FIXNUM() {
        return this.MP_NEGATIVE_FIXNUM;
    }

    public int MP_NEGATIVE_FIXNUM_INT() {
        return this.MP_NEGATIVE_FIXNUM_INT;
    }

    public byte MP_INT8() {
        return this.MP_INT8;
    }

    public byte MP_INT16() {
        return this.MP_INT16;
    }

    public byte MP_INT32() {
        return this.MP_INT32;
    }

    public byte MP_INT64() {
        return this.MP_INT64;
    }

    public byte MP_FIXARRAY() {
        return this.MP_FIXARRAY;
    }

    public int MP_FIXARRAY_INT() {
        return this.MP_FIXARRAY_INT;
    }

    public byte MP_ARRAY16() {
        return this.MP_ARRAY16;
    }

    public byte MP_ARRAY32() {
        return this.MP_ARRAY32;
    }

    public byte MP_FIXMAP() {
        return this.MP_FIXMAP;
    }

    public int MP_FIXMAP_INT() {
        return this.MP_FIXMAP_INT;
    }

    public byte MP_MAP16() {
        return this.MP_MAP16;
    }

    public byte MP_MAP32() {
        return this.MP_MAP32;
    }

    public byte MP_FIXSTR() {
        return this.MP_FIXSTR;
    }

    public int MP_FIXSTR_INT() {
        return this.MP_FIXSTR_INT;
    }

    public byte MP_STR8() {
        return this.MP_STR8;
    }

    public byte MP_STR16() {
        return this.MP_STR16;
    }

    public byte MP_STR32() {
        return this.MP_STR32;
    }

    public byte MP_RAW8() {
        return this.MP_RAW8;
    }

    public byte MP_RAW16() {
        return this.MP_RAW16;
    }

    public byte MP_RAW32() {
        return this.MP_RAW32;
    }

    public void packRawBytes(byte[] data, DataOutputStream out) {
        if (data.length <= this.MAX_8BIT()) {
            out.write(this.MP_RAW8());
            out.write(data.length);
        } else if (data.length <= this.MAX_16BIT()) {
            out.write(this.MP_RAW16());
            out.writeShort(data.length);
        } else {
            out.write(this.MP_RAW32());
            out.writeInt(data.length);
        }
        out.write(data);
    }

    public void packString(String str, DataOutputStream out) {
        byte[] bytes = str.getBytes("UTF-8");
        if (bytes.length <= this.MAX_5BIT()) {
            out.write(bytes.length | this.MP_FIXSTR());
        } else if (bytes.length <= this.MAX_8BIT()) {
            out.write(this.MP_STR8());
            out.write(bytes.length);
        } else if (bytes.length <= this.MAX_16BIT()) {
            out.write(this.MP_STR16());
            out.writeShort(bytes.length);
        } else {
            out.write(this.MP_STR32());
            out.writeInt(bytes.length);
        }
        out.write(bytes);
    }

    public void packLong(long value, DataOutputStream out) {
        if (value >= 0L) {
            if (value <= (long)this.MAX_7BIT()) {
                out.write((int)value | this.MP_FIXNUM());
            } else if (value <= (long)this.MAX_8BIT()) {
                out.write(this.MP_UINT8());
                out.write((int)value);
            } else if (value <= (long)this.MAX_16BIT()) {
                out.write(this.MP_UINT16());
                out.writeShort((int)value);
            } else if (value <= this.MAX_32BIT()) {
                out.write(this.MP_UINT32());
                out.writeInt((int)value);
            } else {
                out.write(this.MP_UINT64());
                out.writeLong(value);
            }
        } else if (value >= (long)(-(this.MAX_5BIT() + 1))) {
            out.write((int)(value & 0xFFL));
        } else if (value >= (long)(-(this.MAX_7BIT() + 1))) {
            out.write(this.MP_INT8());
            out.write((int)value);
        } else if (value >= (long)(-(this.MAX_15BIT() + 1))) {
            out.write(this.MP_INT16());
            out.writeShort((int)value);
        } else if (value >= (long)(-(this.MAX_31BIT() + 1))) {
            out.write(this.MP_INT32());
            out.writeInt((int)value);
        } else {
            out.write(this.MP_INT64());
            out.writeLong(value);
        }
    }

    public <T> void packSeq(Seq<T> s, DataOutputStream out, Codec<T> evidence$1) {
        Codec packer = (Codec)Predef$.MODULE$.implicitly(evidence$1);
        if (s.length() <= this.MAX_4BIT()) {
            out.write(s.length() | this.MP_FIXARRAY());
        } else if (s.length() <= this.MAX_16BIT()) {
            out.write(this.MP_ARRAY16());
            out.writeShort(s.length());
        } else {
            out.write(this.MP_ARRAY32());
            out.writeInt(s.length());
        }
        s.foreach((Function1)new Serializable(out, packer){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$1;
            private final Codec packer$1;

            public final void apply(T x$1) {
                this.packer$1.pack(this.out$1, x$1);
            }
            {
                this.out$1 = out$1;
                this.packer$1 = packer$1;
            }
        });
    }

    public <K, V> void packMap(Map<K, V> map, DataOutputStream out, Codec<K> evidence$2, Codec<V> evidence$3) {
        Codec keyCodec = (Codec)Predef$.MODULE$.implicitly(evidence$2);
        Codec valCodec = (Codec)Predef$.MODULE$.implicitly(evidence$3);
        this.writeMapHeader(map.size(), out);
        map.foreach((Function1)new Serializable(out, keyCodec, valCodec){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$2;
            private final Codec keyCodec$1;
            private final Codec valCodec$1;

            public final void apply(Tuple2<K, V> x0$1) {
                Tuple2<K, V> tuple2 = x0$1;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    this.keyCodec$1.pack(this.out$2, k);
                    this.valCodec$1.pack(this.out$2, v);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.out$2 = out$2;
                this.keyCodec$1 = keyCodec$1;
                this.valCodec$1 = valCodec$1;
            }
        });
    }

    public <K, V> void packMapSeq(Seq<Tuple2<K, V>> map, DataOutputStream out, Codec<K> evidence$4, Codec<V> evidence$5) {
        Codec keyCodec = (Codec)Predef$.MODULE$.implicitly(evidence$4);
        Codec valCodec = (Codec)Predef$.MODULE$.implicitly(evidence$5);
        this.writeMapHeader(map.size(), out);
        map.foreach((Function1)new Serializable(out, keyCodec, valCodec){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$3;
            private final Codec keyCodec$2;
            private final Codec valCodec$2;

            public final void apply(Tuple2<K, V> x0$2) {
                Tuple2<K, V> tuple2 = x0$2;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    this.keyCodec$2.pack(this.out$3, k);
                    this.valCodec$2.pack(this.out$3, v);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.out$3 = out$3;
                this.keyCodec$2 = keyCodec$2;
                this.valCodec$2 = valCodec$2;
            }
        });
    }

    private void writeMapHeader(int mapSize, DataOutputStream out) {
        if (mapSize <= this.MAX_4BIT()) {
            out.write(mapSize | this.MP_FIXMAP());
        } else if (mapSize <= this.MAX_16BIT()) {
            out.write(this.MP_MAP16());
            out.writeShort(mapSize);
        } else {
            out.write(this.MP_MAP32());
            out.writeInt(mapSize);
        }
    }

    public int UNPACK_RAW_AS_STRING() {
        return this.UNPACK_RAW_AS_STRING;
    }

    public int UNPACK_RAW_AS_BYTE_BUFFER() {
        return this.UNPACK_RAW_AS_BYTE_BUFFER;
    }

    public Object unpackRaw(int size, DataInputStream in, int options) {
        if (size < 0) {
            throw new InvalidMsgPackDataException("byte[] to unpack too large for Java (more than 2^31 elements)!");
        }
        byte[] data = new byte[size];
        in.readFully(data);
        return (options & this.UNPACK_RAW_AS_BYTE_BUFFER()) != 0 ? ByteBuffer.wrap(data) : ((options & this.UNPACK_RAW_AS_STRING()) != 0 ? new String(data, "UTF-8") : (Object)data);
    }

    public String unpackString(int size, DataInputStream in) {
        return (String)this.unpackRaw(size, in, this.UNPACK_RAW_AS_STRING());
    }

    public byte[] unpackByteArray(int size, DataInputStream in) {
        return (byte[])this.unpackRaw(size, in, 0);
    }

    public <T> Seq<T> unpackSeq(int size, DataInputStream in, Codec<T> evidence$6) {
        Codec unpacker = (Codec)Predef$.MODULE$.implicitly(evidence$6);
        if (size < 0) {
            throw new InvalidMsgPackDataException("Array to unpack too large for Java (more than 2^31 elements)!");
        }
        Builder vec = package$.MODULE$.Vector().newBuilder();
        for (int i = 0; i < size; ++i) {
            vec.$plus$eq(unpacker.unpack(in));
        }
        return (Seq)vec.result();
    }

    public <K, V> scala.collection.immutable.Map<K, V> unpackMap(int size, DataInputStream in, Codec<K> evidence$7, Codec<V> evidence$8) {
        Codec keyCodec = (Codec)Predef$.MODULE$.implicitly(evidence$7);
        Codec valCodec = (Codec)Predef$.MODULE$.implicitly(evidence$8);
        if (size < 0) {
            throw new InvalidMsgPackDataException("Map to unpack too large for Java (more than 2^31 elements)!");
        }
        ObjectRef map = ObjectRef.create((Object)Predef$.MODULE$.Map().newBuilder());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach((Function1)new Serializable(in, keyCodec, valCodec, map){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$1;
            private final Codec keyCodec$3;
            private final Codec valCodec$3;
            private final ObjectRef map$1;

            public final Builder<Tuple2<K, V>, scala.collection.immutable.Map<K, V>> apply(int i) {
                return ((Builder)this.map$1.elem).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.keyCodec$3.unpack(this.in$1)), this.valCodec$3.unpack(this.in$1)));
            }
            {
                this.in$1 = in$1;
                this.keyCodec$3 = keyCodec$3;
                this.valCodec$3 = valCodec$3;
                this.map$1 = map$1;
            }
        });
        return (scala.collection.immutable.Map)((Builder)map.elem).result();
    }

    private Format$() {
        MODULE$ = this;
        this.MAX_4BIT = 15;
        this.MAX_5BIT = 31;
        this.MAX_7BIT = 127;
        this.MAX_8BIT = 255;
        this.MAX_15BIT = Short.MAX_VALUE;
        this.MAX_16BIT = 65535;
        this.MAX_31BIT = Integer.MAX_VALUE;
        this.MAX_32BIT = 0xFFFFFFFFL;
        this.MP_NULL = (byte)192;
        this.MP_FALSE = (byte)194;
        this.MP_TRUE = (byte)195;
        this.MP_FLOAT = (byte)202;
        this.MP_DOUBLE = (byte)203;
        this.MP_FIXNUM = (byte)0;
        this.MP_UINT8 = (byte)204;
        this.MP_UINT16 = (byte)205;
        this.MP_UINT32 = (byte)206;
        this.MP_UINT64 = (byte)207;
        this.MP_NEGATIVE_FIXNUM = (byte)224;
        this.MP_NEGATIVE_FIXNUM_INT = 224;
        this.MP_INT8 = (byte)208;
        this.MP_INT16 = (byte)209;
        this.MP_INT32 = (byte)210;
        this.MP_INT64 = (byte)211;
        this.MP_FIXARRAY = (byte)144;
        this.MP_FIXARRAY_INT = 144;
        this.MP_ARRAY16 = (byte)220;
        this.MP_ARRAY32 = (byte)221;
        this.MP_FIXMAP = (byte)128;
        this.MP_FIXMAP_INT = 128;
        this.MP_MAP16 = (byte)222;
        this.MP_MAP32 = (byte)223;
        this.MP_FIXSTR = (byte)160;
        this.MP_FIXSTR_INT = 160;
        this.MP_STR8 = (byte)217;
        this.MP_STR16 = (byte)218;
        this.MP_STR32 = (byte)219;
        this.MP_RAW8 = (byte)196;
        this.MP_RAW16 = (byte)197;
        this.MP_RAW32 = (byte)198;
        this.UNPACK_RAW_AS_STRING = 1;
        this.UNPACK_RAW_AS_BYTE_BUFFER = 2;
    }
}

