/*
 * Decompiled with CFR 0.152.
 */
package org.valid4j.matchers.jsonpath;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.valid4j.matchers.jsonpath.IsJson;
import org.valid4j.matchers.jsonpath.WithJsonPath;
import org.valid4j.matchers.jsonpath.WithoutJsonPath;

public class JsonPathMatchers {
    private JsonPathMatchers() {
        throw new AssertionError((Object)"prevent instantiation");
    }

    public static Matcher<? super Object> hasJsonPath(String string) {
        return Matchers.describedAs((String)"has json path %0", JsonPathMatchers.hasJsonPath(string, Matchers.not((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.nullValue(), Matchers.empty()}))), (Object[])new Object[]{string});
    }

    public static <T> Matcher<? super Object> hasJsonPath(String string, Matcher<T> matcher) {
        return JsonPathMatchers.isJson(JsonPathMatchers.withJsonPath(string, matcher));
    }

    public static Matcher<? super Object> hasNoJsonPath(String string) {
        return JsonPathMatchers.isJson(JsonPathMatchers.withoutJsonPath(string, new Predicate[0]));
    }

    public static Matcher<Object> isJson() {
        return JsonPathMatchers.isJson(JsonPathMatchers.withJsonPath("$..*", new Predicate[0]));
    }

    public static Matcher<Object> isJson(Matcher<? super ReadContext> matcher) {
        return new IsJson(matcher);
    }

    public static Matcher<String> isJsonString(Matcher<? super ReadContext> matcher) {
        return new IsJson(matcher);
    }

    public static Matcher<File> isJsonFile(Matcher<? super ReadContext> matcher) {
        return new IsJson(matcher);
    }

    public static Matcher<? super ReadContext> withJsonPath(String string, Predicate ... predicateArray) {
        return JsonPathMatchers.withJsonPath(JsonPath.compile((String)string, (Predicate[])predicateArray));
    }

    public static Matcher<? super ReadContext> withJsonPath(JsonPath jsonPath) {
        return Matchers.describedAs((String)"with json path %0", JsonPathMatchers.withJsonPath(jsonPath, Matchers.not((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.nullValue(), Matchers.empty()}))), (Object[])new Object[]{jsonPath.getPath()});
    }

    public static Matcher<? super ReadContext> withoutJsonPath(String string, Predicate ... predicateArray) {
        return JsonPathMatchers.withoutJsonPath(JsonPath.compile((String)string, (Predicate[])predicateArray));
    }

    public static Matcher<? super ReadContext> withoutJsonPath(JsonPath jsonPath) {
        return new WithoutJsonPath(jsonPath);
    }

    public static <T> Matcher<? super ReadContext> withJsonPath(String string, Matcher<T> matcher) {
        return JsonPathMatchers.withJsonPath(JsonPath.compile((String)string, (Predicate[])new Predicate[0]), matcher);
    }

    public static <T> Matcher<? super ReadContext> withJsonPath(JsonPath jsonPath, Matcher<T> matcher) {
        return new WithJsonPath<T>(jsonPath, matcher);
    }
}

