/*
 * Decompiled with CFR 0.152.
 */
package org.valid4j.matchers.http;

import java.util.Date;
import javax.ws.rs.core.NewCookie;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class NewCookieMatchers {
    private NewCookieMatchers() {
        throw new AssertionError((Object)"Prevent instantiation");
    }

    public static Matcher<NewCookie> withCookieName(String string) {
        return new FeatureMatcher<NewCookie, String>(CoreMatchers.equalTo((Object)string), "with cookie name", "cookie name"){

            protected String featureValueOf(NewCookie newCookie) {
                return newCookie.getName();
            }
        };
    }

    public static Matcher<NewCookie> withCookieValue(String string) {
        return new FeatureMatcher<NewCookie, String>(CoreMatchers.equalTo((Object)string), "with cookie value", "cookie value"){

            protected String featureValueOf(NewCookie newCookie) {
                return newCookie.getValue();
            }
        };
    }

    public static Matcher<NewCookie> withCookiePath(Matcher<String> matcher) {
        return new FeatureMatcher<NewCookie, String>(matcher, "with cookie path", "cookie path"){

            protected String featureValueOf(NewCookie newCookie) {
                return newCookie.getPath();
            }
        };
    }

    public static Matcher<NewCookie> withCookieDomain(String string) {
        return NewCookieMatchers.withCookieDomain((Matcher<String>)CoreMatchers.equalTo((Object)string));
    }

    public static Matcher<NewCookie> withCookieDomain(Matcher<String> matcher) {
        return new FeatureMatcher<NewCookie, String>(matcher, "with cookie domain", "cookie domain"){

            protected String featureValueOf(NewCookie newCookie) {
                return newCookie.getDomain();
            }
        };
    }

    public static Matcher<NewCookie> withCookieVersion(int n) {
        return NewCookieMatchers.withCookieVersion((Matcher<Integer>)CoreMatchers.equalTo((Object)n));
    }

    public static Matcher<NewCookie> withCookieVersion(Matcher<Integer> matcher) {
        return new FeatureMatcher<NewCookie, Integer>(matcher, "with cookie version", "cookie version"){

            protected Integer featureValueOf(NewCookie newCookie) {
                return newCookie.getVersion();
            }
        };
    }

    public static Matcher<NewCookie> withCookieComment(Matcher<String> matcher) {
        return new FeatureMatcher<NewCookie, String>(matcher, "with cookie comment", "cookie comment"){

            protected String featureValueOf(NewCookie newCookie) {
                return newCookie.getComment();
            }
        };
    }

    public static Matcher<NewCookie> withCookieMaxAge(Matcher<Integer> matcher) {
        return new FeatureMatcher<NewCookie, Integer>(matcher, "with cookie max age", "cookie max age"){

            protected Integer featureValueOf(NewCookie newCookie) {
                return newCookie.getMaxAge();
            }
        };
    }

    public static Matcher<NewCookie> withCookieExpiryDate(Matcher<Date> matcher) {
        return new FeatureMatcher<NewCookie, Date>(matcher, "with cookie expiry date", "cookie expiry date"){

            protected Date featureValueOf(NewCookie newCookie) {
                return newCookie.getExpiry();
            }
        };
    }

    public static Matcher<NewCookie> isCookieSecure() {
        return new TypeSafeMatcher<NewCookie>(){

            protected boolean matchesSafely(NewCookie newCookie) {
                return newCookie.isSecure();
            }

            public void describeTo(Description description) {
                description.appendText("is cookie secure");
            }
        };
    }

    public static Matcher<NewCookie> isCookieHttpOnly() {
        return new TypeSafeMatcher<NewCookie>(){

            protected boolean matchesSafely(NewCookie newCookie) {
                return newCookie.isHttpOnly();
            }

            public void describeTo(Description description) {
                description.appendText("is cookie http only");
            }
        };
    }
}

