/*
 * Decompiled with CFR 0.152.
 */
package org.valid4j.matchers.http;

import java.util.Objects;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

class HasStatusMatcher
extends TypeSafeMatcher<Response> {
    private final int statusCode;
    private final String reason;

    public HasStatusMatcher(Response.StatusType statusType) {
        this(statusType.getStatusCode(), statusType.getReasonPhrase());
    }

    public HasStatusMatcher(int n, String string) {
        this.statusCode = n;
        this.reason = string;
    }

    public void describeTo(Description description) {
        description.appendText("has status ").appendValue((Object)HasStatusMatcher.describe(this.statusCode, this.reason));
    }

    protected boolean matchesSafely(Response response) {
        Response.StatusType statusType = response.getStatusInfo();
        return this.statusCode == statusType.getStatusCode() && Objects.equals(this.reason, statusType.getReasonPhrase());
    }

    protected void describeMismatchSafely(Response response, Description description) {
        description.appendText("status was ").appendValue((Object)HasStatusMatcher.describe(response.getStatusInfo()));
    }

    private static StringBuilder describe(Response.StatusType statusType) {
        return HasStatusMatcher.describe(statusType.getStatusCode(), statusType.getReasonPhrase());
    }

    private static StringBuilder describe(int n, String string) {
        return new StringBuilder().append(n).append(" - ").append(string);
    }
}

