/*
 * Decompiled with CFR 0.152.
 */
package org.valid4j.matchers.http;

import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class HasHeaderWithValueMatcher
extends TypeSafeDiagnosingMatcher<Response> {
    private final String headerName;
    private final Matcher<?> valueMatcher;

    public HasHeaderWithValueMatcher(String string, Matcher<?> matcher) {
        this.headerName = string;
        this.valueMatcher = matcher;
    }

    protected boolean matchesSafely(Response response, Description description) {
        MultivaluedMap multivaluedMap = response.getHeaders();
        if (multivaluedMap.containsKey((Object)this.headerName)) {
            Object object = multivaluedMap.getFirst((Object)this.headerName);
            if (!this.valueMatcher.matches(object)) {
                description.appendText("header ").appendValue((Object)this.headerName).appendText(" was ").appendValue(object);
                return false;
            }
            return true;
        }
        description.appendText("header ").appendValue((Object)this.headerName).appendText(" was missing");
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("has header ").appendValue((Object)this.headerName).appendText(" with value ").appendDescriptionOf(this.valueMatcher);
    }
}

