/*
 * Decompiled with CFR 0.152.
 */
package org.valid4j.matchers.http;

import java.util.Map;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class HasCookieWithValueMatcher
extends TypeSafeDiagnosingMatcher<Response> {
    private final String cookieName;
    private final Matcher<NewCookie> cookieMatcher;

    public HasCookieWithValueMatcher(String string, Matcher<NewCookie> matcher) {
        this.cookieName = string;
        this.cookieMatcher = matcher;
    }

    protected boolean matchesSafely(Response response, Description description) {
        Map map = response.getCookies();
        NewCookie newCookie = (NewCookie)map.get(this.cookieName);
        if (newCookie != null) {
            if (this.cookieMatcher.matches((Object)newCookie)) {
                return true;
            }
            description.appendText("cookie ").appendValue((Object)this.cookieName).appendText(" ").appendValue((Object)newCookie);
            return false;
        }
        description.appendText("cookie ").appendValue((Object)this.cookieName).appendText(" not found");
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("has cookie ").appendValue((Object)this.cookieName).appendText(" ").appendDescriptionOf(this.cookieMatcher);
    }
}

