/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.test;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Conventions;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.vaadin.spring.test.VaadinScopes;
import org.vaadin.spring.test.annotation.VaadinAppConfiguration;

public class VaadinTestExecutionListener
extends AbstractTestExecutionListener {
    public static final String SET_UP_SCOPES_ATTRIBUTE = Conventions.getQualifiedAttributeName(VaadinTestExecutionListener.class, (String)"setUpScopes");
    private static final Logger logger = LoggerFactory.getLogger(VaadinTestExecutionListener.class);

    public void prepareTestInstance(TestContext testContext) throws Exception {
        this.setUpVaadinScopesIfNecessary(testContext);
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        this.setUpVaadinScopesIfNecessary(testContext);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        this.tearDownVaadinScopesIfNecessary(testContext);
    }

    private boolean notAnnotatedWithVaadinAppConfiguration(TestContext testContext) {
        return AnnotationUtils.findAnnotation((Class)testContext.getTestClass(), VaadinAppConfiguration.class) == null;
    }

    private boolean alreadySetUpVaadinScopes(TestContext testContext) {
        return Boolean.TRUE.equals(testContext.getAttribute(SET_UP_SCOPES_ATTRIBUTE));
    }

    private synchronized void setUpVaadinScopesIfNecessary(TestContext testContext) {
        if (this.notAnnotatedWithVaadinAppConfiguration(testContext) || this.alreadySetUpVaadinScopes(testContext)) {
            logger.debug("No need to set up Vaadin scopes for test context [{}]", (Object)testContext);
            return;
        }
        VaadinScopes.setUp();
        testContext.setAttribute(SET_UP_SCOPES_ATTRIBUTE, (Object)Boolean.TRUE);
    }

    private synchronized void tearDownVaadinScopesIfNecessary(TestContext testContext) {
        if (this.notAnnotatedWithVaadinAppConfiguration(testContext) || !this.alreadySetUpVaadinScopes(testContext)) {
            logger.debug("No need to tear down Vaadin scopes for test context [{}]", (Object)testContext);
            return;
        }
        VaadinScopes.tearDown();
        testContext.removeAttribute(SET_UP_SCOPES_ATTRIBUTE);
    }
}

