/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.boot;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.vaadin.spring.i18n.I18N;
import org.vaadin.spring.i18n.annotation.EnableI18N;

@Configuration
@ConditionalOnClass(value={I18N.class})
public class I18NAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(I18NAutoConfiguration.class);

    @Configuration
    @EnableI18N
    static class EnableI18NConfiguration
    implements InitializingBean {
        EnableI18NConfiguration() {
        }

        public void afterPropertiesSet() throws Exception {
            logger.debug("{} initialized", (Object)this.getClass().getName());
        }
    }
}

