/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.boot;

import com.vaadin.server.VaadinServlet;
import com.vaadin.spring.boot.VaadinAutoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.vaadin.spring.annotation.EnableVaadinExtensions;
import org.vaadin.spring.config.VaadinExtensionsConfiguration;
import org.vaadin.spring.servlet.Vaadin4SpringServlet;

@Configuration
@ConditionalOnClass(value={VaadinExtensionsConfiguration.class})
@AutoConfigureBefore(value={VaadinAutoConfiguration.class})
public class ExtensionsAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(ExtensionsAutoConfiguration.class);

    @Configuration
    @EnableVaadinExtensions
    static class EnableExtensionsConfiguration
    implements InitializingBean {
        EnableExtensionsConfiguration() {
        }

        public void afterPropertiesSet() throws Exception {
            logger.debug("{} initialized", (Object)this.getClass().getName());
        }

        @Bean
        @ConditionalOnMissingBean
        VaadinServlet vaadinServlet() {
            return new Vaadin4SpringServlet();
        }
    }
}

