/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.util;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.unitils.core.util.ArrayAndCollectionFormatter;
import org.unitils.reflectionassert.util.HibernateUtil;

public class ObjectFormatter {
    public static final String MOCK_NAME_CHAIN_SEPARATOR = "##chained##";
    protected int maxDepth;
    protected int maxNrArrayOrCollectionElements;
    protected ArrayAndCollectionFormatter arrayAndCollectionFormatter;

    public ObjectFormatter() {
        this(3, 15);
    }

    public ObjectFormatter(int maxDepth, int maxNrArrayOrCollectionElements) {
        this.maxDepth = maxDepth;
        this.maxNrArrayOrCollectionElements = maxNrArrayOrCollectionElements;
        this.arrayAndCollectionFormatter = new ArrayAndCollectionFormatter(maxNrArrayOrCollectionElements, this);
    }

    public String format(Object object) {
        StringBuilder result = new StringBuilder();
        this.formatImpl(object, 0, result);
        return result.toString();
    }

    protected void formatImpl(Object object, int currentDepth, StringBuilder result) {
        if ((object = HibernateUtil.getUnproxiedValue(object)) == null) {
            result.append(String.valueOf(object));
            return;
        }
        if (this.formatString(object, result)) {
            return;
        }
        if (this.formatNumberOrDate(object, result)) {
            return;
        }
        Class<?> type = object.getClass();
        if (this.formatCharacter(object, type, result)) {
            return;
        }
        if (this.formatPrimitiveOrEnum(object, type, result)) {
            return;
        }
        if (this.formatMock(object, result)) {
            return;
        }
        if (this.formatProxy(object, type, result)) {
            return;
        }
        if (this.formatJavaLang(object, result, type)) {
            return;
        }
        if (type.isArray()) {
            this.arrayAndCollectionFormatter.formatArray(object, currentDepth, result);
            return;
        }
        if (object instanceof Collection) {
            this.arrayAndCollectionFormatter.formatCollection((Collection)object, currentDepth, result);
            return;
        }
        if (object instanceof Map) {
            this.arrayAndCollectionFormatter.formatMap((Map)object, currentDepth, result);
            return;
        }
        if (currentDepth >= this.maxDepth) {
            result.append(ClassUtils.getShortClassName(type));
            result.append("<...>");
            return;
        }
        if (this.formatFile(object, result)) {
            return;
        }
        this.formatObject(object, currentDepth, result);
    }

    protected boolean formatJavaLang(Object object, StringBuilder result, Class<?> type) {
        if (type.getName().startsWith("java.lang")) {
            result.append(String.valueOf(object));
            return true;
        }
        return false;
    }

    protected boolean formatPrimitiveOrEnum(Object object, Class<?> type, StringBuilder result) {
        if (type.isPrimitive() || type.isEnum()) {
            result.append(String.valueOf(object));
            return true;
        }
        return false;
    }

    protected boolean formatCharacter(Object object, Class<?> type, StringBuilder result) {
        if (object instanceof Character || Character.TYPE.equals(type)) {
            result.append('\'');
            result.append(String.valueOf(object));
            result.append('\'');
            return true;
        }
        return false;
    }

    protected boolean formatNumberOrDate(Object object, StringBuilder result) {
        if (object instanceof Number || object instanceof Date) {
            result.append(String.valueOf(object));
            return true;
        }
        return false;
    }

    protected boolean formatString(Object object, StringBuilder result) {
        if (object instanceof String) {
            result.append('\"');
            result.append(object);
            result.append('\"');
            return true;
        }
        return false;
    }

    protected void formatObject(Object object, int currentDepth, StringBuilder result) {
        Class<?> type = object.getClass();
        result.append(ClassUtils.getShortClassName(type));
        result.append("<");
        this.formatFields(object, type, currentDepth, result);
        result.append(">");
    }

    protected void formatFields(Object object, Class<?> clazz, int currentDepth, StringBuilder result) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (int i = 0; i < fields.length; ++i) {
            AccessibleObject field = fields[i];
            if (Modifier.isTransient(((Field)field).getModifiers()) || Modifier.isStatic(((Field)field).getModifiers()) || ((Field)field).isSynthetic()) continue;
            try {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(((Field)field).getName());
                result.append("=");
                this.formatImpl(((Field)field).get(object), currentDepth + 1, result);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new InternalError("Unexpected IllegalAccessException");
            }
        }
        for (Class<?> superclazz = clazz.getSuperclass(); superclazz != null && !superclazz.getName().startsWith("java.lang"); superclazz = superclazz.getSuperclass()) {
            this.formatFields(object, superclazz, currentDepth, result);
        }
    }

    protected boolean formatMock(Object object, StringBuilder result) {
        try {
            Class<?> proxyUtilsClass = this.getProxyUtilsClass();
            if (proxyUtilsClass == null) {
                return false;
            }
            String mockName = (String)proxyUtilsClass.getMethod("getMockName", Object.class).invoke(null, object);
            if (mockName == null) {
                return false;
            }
            mockName = mockName.replaceAll(MOCK_NAME_CHAIN_SEPARATOR, ".");
            if (this.isDummy(object)) {
                result.append("Dummy<");
            } else {
                result.append("Mock<");
            }
            result.append(mockName);
            result.append(">");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isDummy(Object object) {
        Class<?> clazz = object.getClass();
        Class<?> dummyObjectClass = this.getDummyObjectClass();
        return dummyObjectClass != null && dummyObjectClass.isAssignableFrom(clazz);
    }

    protected boolean formatProxy(Object object, Class<?> type, StringBuilder result) {
        if (Proxy.isProxyClass(type)) {
            result.append("Proxy<?>");
            return true;
        }
        String className = ClassUtils.getShortClassName(object.getClass());
        int index = className.indexOf("..EnhancerByCGLIB..");
        if (index > 0) {
            result.append("Proxy<");
            result.append(className.substring(0, index));
            result.append(">");
            return true;
        }
        return false;
    }

    protected boolean formatFile(Object object, StringBuilder result) {
        if (object instanceof File) {
            result.append("File<");
            result.append(((File)object).getPath());
            result.append(">");
            return true;
        }
        return false;
    }

    protected Class<?> getDummyObjectClass() {
        try {
            return Class.forName("org.unitils.mock.dummy.DummyObject");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected Class<?> getProxyUtilsClass() {
        try {
            return Class.forName("org.unitils.mock.core.proxy.ProxyUtils");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

