/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.tools.taskmanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.unfoldingword.tools.taskmanager.ManagedTask;

public class TaskManager {
    private static Map<String, Integer> mTaskKeys = new HashMap<String, Integer>();
    private static Map<Integer, ManagedTask> mTaskMap = new HashMap<Integer, ManagedTask>();
    private static Map<String, List<Integer>> mGroupTasksMap = new HashMap<String, List<Integer>>();
    private static Map<Integer, List<String>> mTaskGroupsMap = new HashMap<Integer, List<String>>();
    private static int mCurrentTaskIndex = 0;
    private static final int KEEP_ALIVE_TIME = 1;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT;
    private static int NUMBER_OF_CORES;
    private final BlockingQueue<Runnable> mWorkQueue = new LinkedBlockingQueue<Runnable>();
    private final ThreadPoolExecutor mThreadPool = new ThreadPoolExecutor(NUMBER_OF_CORES, NUMBER_OF_CORES * 2, 1L, KEEP_ALIVE_TIME_UNIT, this.mWorkQueue);
    private static TaskManager sInstance;

    private TaskManager() {
    }

    public static TaskManager getsInstance() {
        return sInstance;
    }

    public static int addTask(ManagedTask task) {
        mTaskMap.put(++mCurrentTaskIndex, task);
        task.setTaskId(mCurrentTaskIndex);
        TaskManager.queueTask(task);
        return mCurrentTaskIndex;
    }

    public static boolean addTask(ManagedTask task, String key) {
        if (!mTaskKeys.containsKey(key)) {
            int index = TaskManager.addTask(task);
            task.setTaskId(key);
            mTaskKeys.put(key, index);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean groupTask(ManagedTask task, String group) {
        TaskManager taskManager = sInstance;
        synchronized (taskManager) {
            if (task != null && task.getTaskId() != null) {
                if (task.getTaskId() instanceof String) {
                    if (mTaskKeys.containsKey(task.getTaskId())) {
                        TaskManager.setGroup(mTaskKeys.get(task.getTaskId()), group);
                    }
                } else if (task.getTaskId() instanceof Integer && mTaskMap.containsKey(task.getTaskId())) {
                    TaskManager.setGroup((Integer)task.getTaskId(), group);
                }
            }
        }
        return false;
    }

    private static void setGroup(int id, String group) {
        ArrayList<Object> l;
        if (mGroupTasksMap.containsKey(group)) {
            if (!mGroupTasksMap.get(group).contains(id)) {
                mGroupTasksMap.get(group).add(id);
            }
        } else {
            l = new ArrayList<Object>();
            l.add(id);
            mGroupTasksMap.put(group, l);
        }
        if (mTaskGroupsMap.containsKey(id)) {
            if (!mTaskGroupsMap.get(id).contains(group)) {
                mTaskGroupsMap.get(id).add(group);
            }
        } else {
            l = new ArrayList();
            l.add(group);
            mTaskGroupsMap.put(id, l);
        }
    }

    public static boolean isTaskFinished(int id) {
        return mTaskMap.get(id).isFinished();
    }

    public static ManagedTask getTask(Object id) {
        if (id instanceof String) {
            return TaskManager.getTask((String)id);
        }
        if (id instanceof Integer) {
            return TaskManager.getTask((Integer)id);
        }
        return null;
    }

    private static ManagedTask getTask(int id) {
        if (mTaskMap.containsKey(id)) {
            return mTaskMap.get(id);
        }
        return null;
    }

    private static ManagedTask getTask(String key) {
        if (mTaskKeys.containsKey(key)) {
            return TaskManager.getTask(mTaskKeys.get(key));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTask(Object id) {
        if (id != null) {
            TaskManager taskManager = sInstance;
            synchronized (taskManager) {
                if (id instanceof String) {
                    TaskManager.clearTask((String)id);
                } else if (id instanceof Integer) {
                    TaskManager.clearTask((int)((Integer)id));
                }
            }
        }
    }

    public static void clearTask(ManagedTask task) {
        if (task != null) {
            TaskManager.clearTask(task.getTaskId());
        }
    }

    public static List<ManagedTask> getGroupedTasks(String group) {
        ArrayList<ManagedTask> tasks = new ArrayList<ManagedTask>();
        List<Integer> ids = mGroupTasksMap.get(group);
        if (ids != null) {
            for (Integer id : ids) {
                ManagedTask t = TaskManager.getTask(id);
                if (t == null) continue;
                tasks.add(t);
            }
        }
        return tasks;
    }

    private static boolean clearTask(Integer id) {
        if (id != null && mTaskMap.containsKey(id) && (mTaskMap.get(id).isFinished() || mTaskMap.get(id).isCanceled())) {
            mTaskMap.remove(id);
            List<String> groups = mTaskGroupsMap.get(id);
            if (groups != null) {
                for (String group : groups) {
                    mGroupTasksMap.get(group).remove(id);
                    if (mGroupTasksMap.get(group).size() != 0) continue;
                    mGroupTasksMap.remove(group);
                }
                mTaskGroupsMap.remove(id);
            }
            return true;
        }
        return false;
    }

    private static void clearTask(String key) {
        if (mTaskKeys.containsKey(key) && TaskManager.clearTask(mTaskKeys.get(key))) {
            mTaskKeys.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelAll() {
        ManagedTask[] runnableArray = new ManagedTask[TaskManager.sInstance.mWorkQueue.size()];
        TaskManager.sInstance.mWorkQueue.toArray(runnableArray);
        int len = runnableArray.length;
        TaskManager taskManager = sInstance;
        synchronized (taskManager) {
            for (int runnableIndex = 0; runnableIndex < len; ++runnableIndex) {
                Thread thread = runnableArray[runnableIndex].getThread();
                if (thread == null) continue;
                thread.interrupt();
            }
        }
    }

    private static void queueTask(ManagedTask task) {
        TaskManager.sInstance.mThreadPool.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelTask(ManagedTask task) {
        if (task != null) {
            TaskManager taskManager = sInstance;
            synchronized (taskManager) {
                Thread thread = task.getThread();
                if (thread != null) {
                    thread.interrupt();
                }
                task.stop();
            }
            TaskManager.sInstance.mThreadPool.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killGroup(String group) {
        TaskManager taskManager = sInstance;
        synchronized (taskManager) {
            List<ManagedTask> tasks = TaskManager.getGroupedTasks(group);
            for (ManagedTask t : tasks) {
                TaskManager.cancelTask(t);
                TaskManager.clearTask(t);
            }
        }
    }

    static {
        NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
        sInstance = null;
        KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
        sInstance = new TaskManager();
    }
}

