/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.tools.taskmanager;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import org.unfoldingword.tools.taskmanager.ManagedTask;
import org.unfoldingword.tools.taskmanager.TaskManager;

public class SimpleTaskWatcher
implements ManagedTask.OnFinishedListener,
ManagedTask.OnProgressListener,
ManagedTask.OnStartListener,
DialogInterface.OnCancelListener,
ManagedTask.OnIdChangedListener {
    private final Context mContext;
    private final int mTitleRes;
    private final int mIconRes;
    private ProgressDialog mProgressDialog;
    private Object mTaskId;
    private boolean mWatching = false;
    private OnFinishedListener mOnFinishedListener;
    private OnCanceledListener mOnCanceledListener;

    public SimpleTaskWatcher(Context context, int titleRes) {
        this.mContext = context;
        this.mTitleRes = titleRes;
        this.mIconRes = 0;
    }

    public SimpleTaskWatcher(Context context, int titleRes, int iconRes) {
        this.mContext = context;
        this.mTitleRes = titleRes;
        this.mIconRes = iconRes;
    }

    public void setOnFinishedListener(OnFinishedListener listener) {
        this.mOnFinishedListener = listener;
    }

    public void setOnCanceledListener(OnCanceledListener listener) {
        this.mOnCanceledListener = listener;
    }

    public boolean isWatching() {
        return this.mWatching;
    }

    public boolean watch(Object taskId) {
        if (!this.mWatching) {
            if (taskId != null) {
                ManagedTask task = TaskManager.getTask(taskId);
                return this.connectTask(task);
            }
            Log.w(null, (String)"You cannot watch a task with id NULL");
            return false;
        }
        Log.w(null, (String)"The watcher is already watching a task. Did you forget to call stop() first?");
        return false;
    }

    public boolean watch(ManagedTask task) {
        if (!this.mWatching) {
            return this.connectTask(task);
        }
        Log.w(null, (String)"The watcher is already watching a task. Did you forget to call stop() first?");
        return false;
    }

    private boolean connectTask(ManagedTask task) {
        if (task != null) {
            this.mWatching = true;
            task.addOnIdChangedListener(this);
            task.addOnFinishedListener(this);
            task.addOnProgressListener(this);
            task.addOnStartListener(this);
            return true;
        }
        Log.w(null, (String)"The task does not exist");
        return false;
    }

    public void stop() {
        if (this.mTaskId != null) {
            ManagedTask task = TaskManager.getTask(this.mTaskId);
            if (task != null) {
                task.removeOnIdChangedListener(this);
                task.removeOnFinishedListener(this);
                task.removeOnProgressListener(this);
                task.removeOnStartListener(this);
            }
            this.mTaskId = null;
        }
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
        }
        this.mWatching = false;
    }

    @Override
    public void onTaskFinished(final ManagedTask task) {
        TaskManager.clearTask(task);
        Handler hand = new Handler(Looper.getMainLooper());
        hand.post(new Runnable(){

            @Override
            public void run() {
                if (SimpleTaskWatcher.this.mProgressDialog != null && SimpleTaskWatcher.this.mProgressDialog.isShowing()) {
                    SimpleTaskWatcher.this.mProgressDialog.dismiss();
                }
                if (SimpleTaskWatcher.this.mOnFinishedListener != null) {
                    SimpleTaskWatcher.this.mOnFinishedListener.onFinished(task);
                }
            }
        });
    }

    @Override
    public void onTaskProgress(final ManagedTask task, final double progress, final String message, boolean secondary) {
        if (!task.isFinished()) {
            Handler hand = new Handler(Looper.getMainLooper());
            hand.post(new Runnable(){

                @Override
                public void run() {
                    if (task.isFinished() || !SimpleTaskWatcher.this.mWatching) {
                        if (SimpleTaskWatcher.this.mProgressDialog != null) {
                            SimpleTaskWatcher.this.mProgressDialog.dismiss();
                        }
                        return;
                    }
                    if (SimpleTaskWatcher.this.mProgressDialog == null) {
                        SimpleTaskWatcher.this.mProgressDialog = new ProgressDialog(SimpleTaskWatcher.this.mContext);
                        SimpleTaskWatcher.this.mProgressDialog.setProgressStyle(1);
                        if (SimpleTaskWatcher.this.mOnCanceledListener != null) {
                            SimpleTaskWatcher.this.mProgressDialog.setCancelable(true);
                            SimpleTaskWatcher.this.mProgressDialog.setOnCancelListener((DialogInterface.OnCancelListener)SimpleTaskWatcher.this);
                        } else {
                            SimpleTaskWatcher.this.mProgressDialog.setCancelable(false);
                        }
                        SimpleTaskWatcher.this.mProgressDialog.setCanceledOnTouchOutside(false);
                        SimpleTaskWatcher.this.mProgressDialog.setMax(task.maxProgress());
                        if (SimpleTaskWatcher.this.mIconRes != 0) {
                            SimpleTaskWatcher.this.mProgressDialog.setIcon(SimpleTaskWatcher.this.mIconRes);
                        }
                        SimpleTaskWatcher.this.mProgressDialog.setTitle(SimpleTaskWatcher.this.mTitleRes);
                        SimpleTaskWatcher.this.mProgressDialog.setMessage((CharSequence)"");
                    }
                    if (!SimpleTaskWatcher.this.mProgressDialog.isShowing()) {
                        SimpleTaskWatcher.this.mProgressDialog.show();
                    }
                    if (progress == -1.0) {
                        SimpleTaskWatcher.this.mProgressDialog.setIndeterminate(true);
                        SimpleTaskWatcher.this.mProgressDialog.setProgress(SimpleTaskWatcher.this.mProgressDialog.getMax());
                    } else {
                        SimpleTaskWatcher.this.mProgressDialog.setIndeterminate(false);
                        SimpleTaskWatcher.this.mProgressDialog.setProgress((int)Math.ceil(progress * (double)SimpleTaskWatcher.this.mProgressDialog.getMax()));
                    }
                    if (!message.isEmpty()) {
                        SimpleTaskWatcher.this.mProgressDialog.setMessage((CharSequence)message);
                    } else {
                        SimpleTaskWatcher.this.mProgressDialog.setMessage((CharSequence)"");
                    }
                }
            });
        }
    }

    @Override
    public void onTaskStart(ManagedTask task) {
    }

    public void onCancel(DialogInterface dialog) {
        ManagedTask task = TaskManager.getTask(this.mTaskId);
        if (task != null) {
            TaskManager.cancelTask(task);
            TaskManager.clearTask(task);
        }
        if (this.mOnCanceledListener != null) {
            this.mOnCanceledListener.onCanceled(task);
        }
    }

    @Override
    public void onTaskIdChanged(ManagedTask task) {
        this.mTaskId = task.getTaskId();
    }

    public static interface OnFinishedListener {
        public void onFinished(ManagedTask var1);
    }

    public static interface OnCanceledListener {
        public void onCanceled(ManagedTask var1);
    }
}

