/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.taskmanager;

import android.os.Bundle;
import android.os.Process;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class ManagedTask
implements Runnable {
    private Thread mThread;
    private boolean mFinished;
    private List mFinishListeners = Collections.synchronizedList(new ArrayList());
    private Object mTaskId;
    private List mProgressListeners = Collections.synchronizedList(new ArrayList());
    private double mProgress = -1.0;
    private String mProgressMessage = "";
    private boolean mIsStopped = false;
    private List mStartListeners = Collections.synchronizedList(new ArrayList());
    private boolean mIsRunning = false;
    private List mOnIdChangedListeners = Collections.synchronizedList(new ArrayList());
    protected int mThreadPriority = 10;
    private Bundle mArgs = null;

    public ManagedTask ManagedTask() {
        return this;
    }

    public void setArgs(Bundle args) {
        this.mArgs = args;
    }

    public Bundle getArgs() {
        return this.mArgs;
    }

    protected final void setThreadPriority(int priority) {
        this.mThreadPriority = priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Iterator it;
        List list;
        Process.setThreadPriority((int)this.mThreadPriority);
        this.mThread = Thread.currentThread();
        try {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            this.mIsRunning = true;
            list = this.mStartListeners;
            synchronized (list) {
                it = this.mStartListeners.iterator();
                while (it.hasNext()) {
                    try {
                        ((OnStartListener)it.next()).onStart(this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.start();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            Thread.interrupted();
        }
        this.mIsRunning = false;
        this.mFinished = true;
        list = this.mFinishListeners;
        synchronized (list) {
            it = this.mFinishListeners.iterator();
            while (it.hasNext()) {
                try {
                    ((OnFinishedListener)it.next()).onFinished(this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.onStop();
    }

    public final void run(Thread thread) {
        this.mThread = thread;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            Thread.interrupted();
        }
    }

    public ManagedTask then(ManagedTask task) {
        this.delegate(task);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void delegate(ManagedTask task) {
        List list = this.mProgressListeners;
        synchronized (list) {
            Iterator it = this.mProgressListeners.iterator();
            while (it.hasNext()) {
                task.addOnProgressListener((OnProgressListener)it.next());
            }
        }
        task.run(this.mThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTaskId(Object id) {
        this.mTaskId = id;
        List list = this.mOnIdChangedListeners;
        synchronized (list) {
            Iterator it = this.mOnIdChangedListeners.iterator();
            while (it.hasNext()) {
                try {
                    ((OnIdChangedListener)it.next()).onChanged(this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public final Object getTaskId() {
        return this.mTaskId;
    }

    protected final void publishProgress(double progress, String message) {
        this.publishProgress(progress, message, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void publishProgress(double progress, String message, boolean secondary) {
        if (!secondary) {
            this.mProgress = progress;
            this.mProgressMessage = message;
        }
        if (!this.isFinished()) {
            List list = this.mProgressListeners;
            synchronized (list) {
                Iterator it = this.mProgressListeners.iterator();
                while (it.hasNext()) {
                    try {
                        ((OnProgressListener)it.next()).onProgress(this, progress, message, secondary);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public final void addOnProgressListener(OnProgressListener listener) {
        if (!this.mProgressListeners.contains(listener) && listener != null) {
            this.mProgressListeners.add(listener);
            if (!this.isFinished()) {
                try {
                    listener.onProgress(this, this.mProgress, this.mProgressMessage, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public final void addOnIdChangedListener(OnIdChangedListener listener) {
        if (!this.mOnIdChangedListeners.contains(listener) && listener != null) {
            this.mOnIdChangedListeners.add(listener);
            try {
                listener.onChanged(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void removeOnIdChangedListener(OnIdChangedListener listener) {
        this.mOnIdChangedListeners.remove(listener);
    }

    public final void removeAllOnIdChangedListener() {
        this.mOnIdChangedListeners.clear();
    }

    public final void removeOnProgressListener(OnProgressListener listener) {
        if (listener != null) {
            this.mProgressListeners.remove(listener);
        }
    }

    public final void removeAllOnProgressListener() {
        this.mProgressListeners.clear();
    }

    public final void addOnFinishedListener(OnFinishedListener listener) {
        if (!this.mFinishListeners.contains(listener) && listener != null) {
            this.mFinishListeners.add(listener);
            if (this.isFinished()) {
                try {
                    listener.onFinished(this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public final void removeOnFinishedListener(OnFinishedListener listener) {
        if (listener != null) {
            this.mFinishListeners.remove(listener);
        }
    }

    public final void removeAllOnFinishedListener() {
        this.mFinishListeners.clear();
    }

    public final void addOnStartListener(OnStartListener listener) {
        if (!this.mStartListeners.contains(listener) && listener != null) {
            this.mStartListeners.add(listener);
        }
    }

    public final void removeOnStartListener(OnStartListener listener) {
        this.mStartListeners.remove(listener);
    }

    public final void removeAllOnStartListener() {
        this.mStartListeners.clear();
    }

    public abstract void start();

    public int maxProgress() {
        return 100;
    }

    public final Thread getThread() {
        return this.mThread;
    }

    public final boolean isFinished() {
        return this.mFinished;
    }

    public final boolean isRunning() {
        return this.mIsRunning;
    }

    public final boolean isCanceled() {
        return this.mIsStopped;
    }

    public final void stop() {
        this.mIsStopped = true;
    }

    public final void destroy() {
        this.mIsStopped = true;
        this.mStartListeners.clear();
        this.mFinishListeners.clear();
        this.mProgressListeners.clear();
    }

    protected void onStop() {
    }

    public final boolean interrupted() {
        if (this.mThread != null) {
            return this.mThread.isInterrupted() || this.mIsStopped;
        }
        return this.mIsStopped;
    }

    public static interface OnIdChangedListener {
        public void onChanged(ManagedTask var1);
    }

    public static interface OnStartListener {
        public void onStart(ManagedTask var1);
    }

    public static interface OnProgressListener {
        public void onProgress(ManagedTask var1, double var2, String var4, boolean var5);
    }

    public static interface OnFinishedListener {
        public void onFinished(ManagedTask var1);
    }
}

