/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.taskmanager;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import org.unfoldingword.taskmanager.ManagedTask;
import org.unfoldingword.taskmanager.TaskManager;

public class GenericTaskWatcher
implements ManagedTask.OnFinishedListener,
ManagedTask.OnProgressListener,
ManagedTask.OnStartListener,
DialogInterface.OnCancelListener,
ManagedTask.OnIdChangedListener {
    private final Context mContext;
    private final int mTitleRes;
    private final int mIconRes;
    private ProgressDialog mProgressDialog;
    private Object mTaskId;
    private boolean mWatching = false;
    private OnFinishedListener mOnFinishedListener;
    private OnCanceledListener mOnCanceledListener;

    public GenericTaskWatcher(Context context, int titleRes) {
        this.mContext = context;
        this.mTitleRes = titleRes;
        this.mIconRes = 0;
    }

    public GenericTaskWatcher(Context context, int titleRes, int iconRes) {
        this.mContext = context;
        this.mTitleRes = titleRes;
        this.mIconRes = iconRes;
    }

    public void setOnFinishedListener(OnFinishedListener listener) {
        this.mOnFinishedListener = listener;
    }

    public void setOnCanceledListener(OnCanceledListener listener) {
        this.mOnCanceledListener = listener;
    }

    public boolean isWatching() {
        return this.mWatching;
    }

    public boolean watch(Object taskId) {
        if (!this.mWatching) {
            if (taskId != null) {
                ManagedTask task = TaskManager.getTask(taskId);
                return this.connectTask(task);
            }
            Log.w(null, (String)"You cannot watch a task with id NULL");
            return false;
        }
        Log.w(null, (String)"The watcher is already watching a task. Did you forget to call stop() first?");
        return false;
    }

    public boolean watch(ManagedTask task) {
        if (!this.mWatching) {
            return this.connectTask(task);
        }
        Log.w(null, (String)"The watcher is already watching a task. Did you forget to call stop() first?");
        return false;
    }

    private boolean connectTask(ManagedTask task) {
        if (task != null) {
            this.mWatching = true;
            task.addOnIdChangedListener(this);
            task.addOnFinishedListener(this);
            task.addOnProgressListener(this);
            task.addOnStartListener(this);
            return true;
        }
        Log.w(null, (String)"The task does not exist");
        return false;
    }

    public void stop() {
        if (this.mTaskId != null) {
            ManagedTask task = TaskManager.getTask(this.mTaskId);
            if (task != null) {
                task.removeOnIdChangedListener(this);
                task.removeOnFinishedListener(this);
                task.removeOnProgressListener(this);
                task.removeOnStartListener(this);
            }
            this.mTaskId = null;
        }
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
        }
        this.mWatching = false;
    }

    @Override
    public void onFinished(final ManagedTask task) {
        TaskManager.clearTask(task);
        Handler hand = new Handler(Looper.getMainLooper());
        hand.post(new Runnable(){

            @Override
            public void run() {
                if (GenericTaskWatcher.this.mProgressDialog != null && GenericTaskWatcher.this.mProgressDialog.isShowing()) {
                    GenericTaskWatcher.this.mProgressDialog.dismiss();
                }
                if (GenericTaskWatcher.this.mOnFinishedListener != null) {
                    GenericTaskWatcher.this.mOnFinishedListener.onFinished(task);
                }
            }
        });
    }

    @Override
    public void onProgress(final ManagedTask task, final double progress, final String message, boolean secondary) {
        if (!task.isFinished()) {
            Handler hand = new Handler(Looper.getMainLooper());
            hand.post(new Runnable(){

                @Override
                public void run() {
                    if (task.isFinished()) {
                        if (GenericTaskWatcher.this.mProgressDialog != null) {
                            GenericTaskWatcher.this.mProgressDialog.dismiss();
                        }
                        return;
                    }
                    if (GenericTaskWatcher.this.mProgressDialog == null) {
                        GenericTaskWatcher.this.mProgressDialog = new ProgressDialog(GenericTaskWatcher.this.mContext);
                        GenericTaskWatcher.this.mProgressDialog.setProgressStyle(1);
                        if (GenericTaskWatcher.this.mOnCanceledListener != null) {
                            GenericTaskWatcher.this.mProgressDialog.setCancelable(true);
                            GenericTaskWatcher.this.mProgressDialog.setOnCancelListener((DialogInterface.OnCancelListener)GenericTaskWatcher.this);
                        } else {
                            GenericTaskWatcher.this.mProgressDialog.setCancelable(false);
                        }
                        GenericTaskWatcher.this.mProgressDialog.setCanceledOnTouchOutside(false);
                        GenericTaskWatcher.this.mProgressDialog.setMax(task.maxProgress());
                        if (GenericTaskWatcher.this.mIconRes != 0) {
                            GenericTaskWatcher.this.mProgressDialog.setIcon(GenericTaskWatcher.this.mIconRes);
                        }
                        GenericTaskWatcher.this.mProgressDialog.setTitle(GenericTaskWatcher.this.mTitleRes);
                        GenericTaskWatcher.this.mProgressDialog.setMessage((CharSequence)"");
                    }
                    if (!GenericTaskWatcher.this.mProgressDialog.isShowing()) {
                        GenericTaskWatcher.this.mProgressDialog.show();
                    }
                    if (progress == -1.0) {
                        GenericTaskWatcher.this.mProgressDialog.setIndeterminate(true);
                        GenericTaskWatcher.this.mProgressDialog.setProgress(GenericTaskWatcher.this.mProgressDialog.getMax());
                    } else {
                        GenericTaskWatcher.this.mProgressDialog.setIndeterminate(false);
                        GenericTaskWatcher.this.mProgressDialog.setProgress((int)Math.ceil(progress * (double)GenericTaskWatcher.this.mProgressDialog.getMax()));
                    }
                    if (!message.isEmpty()) {
                        GenericTaskWatcher.this.mProgressDialog.setMessage((CharSequence)message);
                    } else {
                        GenericTaskWatcher.this.mProgressDialog.setMessage((CharSequence)"");
                    }
                }
            });
        }
    }

    @Override
    public void onStart(ManagedTask task) {
    }

    public void onCancel(DialogInterface dialog) {
        ManagedTask task = TaskManager.getTask(this.mTaskId);
        if (task != null) {
            TaskManager.cancelTask(task);
            TaskManager.clearTask(task);
        }
        this.mOnCanceledListener.onCanceled(task);
    }

    @Override
    public void onChanged(ManagedTask task) {
        this.mTaskId = task.getTaskId();
    }

    public static interface OnFinishedListener {
        public void onFinished(ManagedTask var1);
    }

    public static interface OnCanceledListener {
        public void onCanceled(ManagedTask var1);
    }
}

