/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.resourcecontainer;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.json.JSONException;
import org.json.JSONObject;
import org.unfoldingword.resourcecontainer.ContainerTools;
import org.unfoldingword.resourcecontainer.FileUtil;
import org.unfoldingword.resourcecontainer.Language;
import org.unfoldingword.resourcecontainer.Project;
import org.unfoldingword.resourcecontainer.Resource;
import org.unfoldingword.resourcecontainer.Semver;
import org.unfoldingword.resourcecontainer.TarUtil;
import org.unfoldingword.tools.jtar.TarInputStream;
import org.unfoldingword.tools.jtar.TarOutputStream;

public class ResourceContainer {
    public static final String version = "0.1";
    public static final String slugDelimiter = "_";
    public static final String fileExtension = "tsrc";
    public static final String baseMimeType = "application/tsrc";
    private static final String CONTENT_DIR = "content";
    public final File path;
    public final JSONObject info;
    public final Map config;
    public final Object toc;
    public final String slug;
    public final Language language;
    public final Project project;
    public final Resource resource;
    public final int modifiedAt;
    public final String contentMimeType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceContainer(File containerDirectory, JSONObject containerInfo) throws JSONException {
        this.path = containerDirectory;
        this.info = containerInfo;
        this.modifiedAt = this.info.getInt("modified_at");
        this.contentMimeType = this.info.getString("content_mime_type");
        this.language = Language.fromJSON(containerInfo.getJSONObject("language"));
        this.project = Project.fromJSON(containerInfo.getJSONObject("project"));
        this.project.languageSlug = this.language.slug;
        this.resource = Resource.fromJSON(containerInfo.getJSONObject("resource"));
        this.resource.projectSlug = this.project.slug;
        this.slug = ContainerTools.makeSlug(this.language.slug, this.project.slug, this.resource.slug);
        File configFile = new File(containerDirectory, "content/config.yml");
        Map tempConfig = null;
        try {
            YamlReader reader = new YamlReader((Reader)new FileReader(configFile));
            Object object = reader.read();
            tempConfig = (Map)object;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (YamlException e) {
            e.printStackTrace();
        }
        finally {
            if (tempConfig == null) {
                tempConfig = new HashMap();
            }
        }
        this.config = tempConfig;
        File tocFile = new File(containerDirectory, "content/toc.yml");
        HashMap tempToc = null;
        try {
            YamlReader reader = new YamlReader((Reader)new FileReader(tocFile));
            tempToc = reader.read();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (YamlException e) {
            e.printStackTrace();
        }
        finally {
            if (tempToc == null) {
                tempToc = new HashMap();
            }
        }
        this.toc = tempToc;
    }

    public static ResourceContainer load(File containerDirectory) throws Exception {
        if (!containerDirectory.exists()) {
            throw new Exception("The resource container does not exist");
        }
        if (!containerDirectory.isDirectory()) {
            throw new Exception("Not an open resource container");
        }
        File packageFile = new File(containerDirectory, "package.json");
        if (!packageFile.exists()) {
            throw new Exception("Not a resource container");
        }
        JSONObject packageJson = new JSONObject(FileUtil.readFileToString(packageFile));
        if (!packageJson.has("package_version")) {
            throw new Exception("Not a resource container");
        }
        if (Semver.gt(packageJson.getString("package_version"), version)) {
            throw new Exception("Unsupported container version");
        }
        if (Semver.lt(packageJson.getString("package_version"), version)) {
            throw new Exception("Outdated container version");
        }
        return new ResourceContainer(containerDirectory, packageJson);
    }

    public static ResourceContainer make(File containerDirectory, JSONObject opts) throws Exception {
        if (containerDirectory.exists()) {
            throw new Exception("Resource container directory already exists");
        }
        throw new Exception("Not implemented yet!");
    }

    public static ResourceContainer open(File containerArchive, File containerDirectory) throws Exception {
        BufferedInputStream in;
        FileInputStream fin;
        if (containerDirectory.exists()) {
            return ResourceContainer.load(containerDirectory);
        }
        if (!containerArchive.exists()) {
            throw new Exception("Missing resource container");
        }
        File tempFile = new File(containerArchive + ".tmp.tar");
        FileOutputStream out = null;
        BZip2CompressorInputStream bzIn = null;
        try {
            int n;
            fin = new FileInputStream(containerArchive);
            in = new BufferedInputStream(fin);
            out = new FileOutputStream(tempFile);
            bzIn = new BZip2CompressorInputStream((InputStream)in);
            byte[] buffer = new byte[2048];
            while ((n = bzIn.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            FileUtil.deleteQuietly(tempFile);
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (bzIn != null) {
                bzIn.close();
            }
        }
        fin = new FileInputStream(tempFile);
        in = new BufferedInputStream(fin);
        TarInputStream tin = new TarInputStream(in);
        try {
            containerDirectory.mkdirs();
            TarUtil.untar(tin, containerDirectory.getAbsolutePath());
        }
        catch (Exception e) {
            FileUtil.deleteQuietly(containerDirectory);
            throw e;
        }
        finally {
            tin.close();
            FileUtil.deleteQuietly(tempFile);
        }
        return ResourceContainer.load(containerDirectory);
    }

    public static File close(File containerDirectory) throws Exception {
        if (!containerDirectory.exists()) {
            throw new Exception("Missing resource container");
        }
        File tempFile = new File(containerDirectory.getAbsolutePath() + ".tmp.tar");
        try (TarOutputStream tout = new TarOutputStream(new BufferedOutputStream(new FileOutputStream(tempFile)));){
            TarUtil.tar(null, containerDirectory.getAbsolutePath(), tout);
        }
        File archive = new File(containerDirectory.getAbsolutePath() + "." + fileExtension);
        BZip2CompressorOutputStream bzOut = null;
        BufferedInputStream in = null;
        try {
            int n;
            FileInputStream fin = new FileInputStream(tempFile);
            in = new BufferedInputStream(fin);
            FileOutputStream out = new FileOutputStream(archive);
            bzOut = new BZip2CompressorOutputStream((OutputStream)out);
            byte[] buffer = new byte[2048];
            while ((n = in.read(buffer)) != -1) {
                bzOut.write(buffer, 0, n);
            }
            bzOut.close();
            in.close();
        }
        catch (Exception e) {
            FileUtil.deleteQuietly(archive);
            throw e;
        }
        finally {
            if (bzOut != null) {
                bzOut.close();
            }
            if (in != null) {
                in.close();
            }
            FileUtil.deleteQuietly(tempFile);
        }
        return archive;
    }

    public String[] chapters() {
        String[] chapters = new File(this.path, CONTENT_DIR).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return new File(dir, filename).isDirectory() && !filename.equals("config.yml") && !filename.equals("toc.yml");
            }
        });
        if (chapters == null) {
            chapters = new String[]{};
        }
        return chapters;
    }

    public String[] chunks(String chapterSlug) {
        final ArrayList chunks = new ArrayList();
        new File(new File(this.path, CONTENT_DIR), chapterSlug).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                chunks.add(filename.split("\\.")[0]);
                return false;
            }
        });
        return chunks.toArray(new String[chunks.size()]);
    }

    public String readChunk(String chapterSlug, String chunkSlug) {
        File chunkFile = new File(new File(new File(this.path, CONTENT_DIR), chapterSlug), chunkSlug + "." + this.chunkExt());
        if (chunkFile.exists() && chunkFile.isFile()) {
            try {
                return FileUtil.readFileToString(chunkFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private String chunkExt() {
        String defaultExt = "txt";
        try {
            switch (this.info.getString("content_mime_type")) {
                case "text/usx": {
                    return "usx";
                }
                case "text/usfm": {
                    return "usfm";
                }
                case "text/markdown": {
                    return "md";
                }
            }
            return defaultExt;
        }
        catch (JSONException e) {
            return defaultExt;
        }
    }
}

