/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.resourcecontainer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class Resource {
    public static final String REGULAR_SLUG = "reg";
    public final String slug;
    public final String name;
    public final String type;
    public final String translateMode;
    public final String checkingLevel;
    public final String version;
    public String comments = "";
    public String pubDate = "";
    public String license = "";
    public String projectSlug = "";
    public final List<Format> formats = new ArrayList<Format>();
    public Map<String, Object> _legacyData = new HashMap<String, Object>();

    public Resource(String slug, String name, String type, String translateMode, String checkingLevel, String version) {
        this.slug = slug;
        this.name = name;
        this.type = type;
        this.translateMode = translateMode;
        this.checkingLevel = checkingLevel;
        this.version = version;
    }

    public boolean hasImportedFormat() {
        for (Format f : this.formats) {
            if (!f.imported) continue;
            return true;
        }
        return false;
    }

    public void addFormat(Format format) {
        this.formats.add(format);
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("slug", (Object)this.slug);
        json.put("name", (Object)this.name);
        json.put("type", (Object)this.type);
        JSONObject statusJson = new JSONObject();
        statusJson.put("translate_mode", (Object)this.translateMode);
        statusJson.put("checking_level", (Object)this.checkingLevel);
        statusJson.put("license", (Object)Resource.deNull(this.license));
        statusJson.put("version", (Object)Resource.deNull(this.version));
        statusJson.put("pub_date", (Object)this.pubDate);
        statusJson.put("comments", (Object)Resource.deNull(this.comments));
        json.put("status", (Object)statusJson);
        return json;
    }

    private static String deNull(String value) {
        if (value == null) {
            value = "";
        }
        return value;
    }

    public static Resource fromJSON(JSONObject json) throws JSONException {
        if (json == null) {
            throw new JSONException("Invalid json");
        }
        JSONObject status = json.getJSONObject("status");
        Resource r = new Resource(json.getString("slug"), json.getString("name"), json.getString("type"), status.getString("translate_mode"), status.getString("checking_level"), status.getString("version"));
        if (status.has("license")) {
            r.license = Resource.deNull(status.getString("license"));
        }
        if (status.has("pub_date")) {
            r.pubDate = Resource.deNull(status.getString("pub_date"));
        }
        if (status.has("comments")) {
            r.comments = Resource.deNull(status.getString("comments"));
        }
        return r;
    }

    public static class Format {
        public String packageVersion;
        public String mimeType;
        public int modifiedAt;
        public String url;
        public boolean imported;

        public Format(String packageVersion, String mimeType, int modifiedAt, String url, boolean imported) {
            this.packageVersion = packageVersion;
            this.mimeType = mimeType;
            this.modifiedAt = modifiedAt;
            this.url = url;
            this.imported = imported;
        }
    }
}

