/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.resourcecontainer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ObjectReader
implements Iterable<ObjectReader> {
    private final Object map;

    public ObjectReader(Object obj) {
        this.map = obj;
    }

    public ObjectReader get(Object key) {
        if (this.map instanceof Map && ((Map)this.map).containsKey(key)) {
            return new ObjectReader(((Map)this.map).get(key));
        }
        if (key instanceof String && this.map instanceof JSONObject && ((JSONObject)this.map).has((String)key)) {
            Object value = null;
            try {
                value = ((JSONObject)this.map).get((String)key);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return new ObjectReader(value);
        }
        if (key instanceof Integer && this.map instanceof JSONArray && (Integer)key >= 0 && ((JSONArray)this.map).length() > (Integer)key) {
            Object value = null;
            try {
                value = ((JSONArray)this.map).get(((Integer)key).intValue());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return new ObjectReader(value);
        }
        if (key instanceof Integer && this.map instanceof List && (Integer)key >= 0 && ((List)this.map).size() > (Integer)key) {
            return new ObjectReader(((List)this.map).get((Integer)key));
        }
        return new ObjectReader(null);
    }

    public List<Object> keys() {
        if (this.map instanceof Map) {
            return new ArrayList<Object>(((Map)this.map).keySet());
        }
        if (this.map instanceof Collection) {
            int size = ((Collection)this.map).size();
            ArrayList<Object> keys = new ArrayList<Object>();
            for (int i = 0; i < size; ++i) {
                keys.add(i);
            }
            return keys;
        }
        if (this.map instanceof JSONArray) {
            int size = ((JSONArray)this.map).length();
            ArrayList<Object> keys = new ArrayList<Object>();
            for (int i = 0; i < size; ++i) {
                keys.add(i);
            }
            return keys;
        }
        if (this.map instanceof JSONObject) {
            ArrayList<Object> keys = new ArrayList<Object>();
            Iterator iter = ((JSONObject)this.map).keys();
            while (iter.hasNext()) {
                keys.add(iter.next());
            }
            return keys;
        }
        return new ArrayList<Object>();
    }

    public Object value() {
        if (this.map != null) {
            return this.map;
        }
        return null;
    }

    public int size() {
        if (this.map instanceof Map) {
            return ((Map)this.map).size();
        }
        if (this.map instanceof Collection) {
            return ((Collection)this.map).size();
        }
        if (this.map instanceof JSONArray) {
            return ((JSONArray)this.map).length();
        }
        if (this.map instanceof JSONObject) {
            return ((JSONObject)this.map).length();
        }
        return 0;
    }

    public boolean isNull() {
        return this.map == null;
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public Iterator<ObjectReader> iterator() {
        return new ObjectIterator(this);
    }

    class ObjectIterator
    implements Iterator<ObjectReader> {
        private final ObjectReader reader;
        private final List<Object> keys;
        private int index = 0;

        private ObjectIterator(ObjectReader reader) {
            this.reader = reader;
            this.keys = reader.keys();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.keys.size();
        }

        @Override
        public ObjectReader next() {
            return this.reader.get(this.keys.get(this.index++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not supported yet");
        }
    }
}

