/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.resourcecontainer;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Link {
    public String title;
    public final String url;
    public final String resource;
    public final String project;
    public final String language;
    public final String arguments;
    public final String protocal;
    public final String chapter;
    public final String chunk;
    public final String lastChunk;

    private Link(String title, String url) {
        this.title = title;
        this.url = url;
        this.protocal = null;
        this.resource = null;
        this.project = null;
        this.chapter = null;
        this.chunk = null;
        this.lastChunk = null;
        this.arguments = null;
        this.language = null;
    }

    private Link(String protocal, String title, String language, String project, String resource, String arguments, String chapter, String chunk, String lastChunk) {
        this.url = null;
        this.protocal = protocal;
        this.title = title;
        this.language = language;
        this.project = project;
        this.resource = resource;
        this.arguments = arguments;
        this.chapter = chapter;
        this.chunk = chunk;
        this.lastChunk = lastChunk;
    }

    public boolean isExternal() {
        return this.url != null;
    }

    public boolean isMedia() {
        return this.protocal != null;
    }

    public boolean isPassage() {
        return this.chapter != null && this.chunk != null;
    }

    public String passageTitle() {
        if (this.isPassage()) {
            String tail = "";
            if (this.lastChunk != null) {
                tail = "-" + this.formatNumber(this.lastChunk);
            }
            return this.formatNumber(this.chapter) + ":" + this.formatNumber(this.chunk) + tail;
        }
        return null;
    }

    private String formatNumber(String value) {
        try {
            return Integer.parseInt(value) + "";
        }
        catch (NumberFormatException numberFormatException) {
            return value.trim().toLowerCase();
        }
    }

    public static Link parseLink(String link) throws Exception {
        Pattern anonymousPattern = Pattern.compile("\\[\\[([^\\]]*)\\]\\]", 32);
        Pattern titledPattern = Pattern.compile("\\[([^\\]]*)\\]\\(([^\\)]*)\\)", 32);
        String linkTitle = null;
        String linkPath = link;
        int numMatches = 1;
        Matcher m = anonymousPattern.matcher(link);
        while (m.find()) {
            if (numMatches > 1) {
                throw new Exception("Invalid link! Multiple links found");
            }
            ++numMatches;
            linkPath = m.group(1).toLowerCase();
        }
        m = titledPattern.matcher(link);
        numMatches = 1;
        while (m.find()) {
            if (numMatches > 1) {
                throw new Exception("Invalid link! Multiple links found");
            }
            ++numMatches;
            linkTitle = m.group(1);
            linkPath = m.group(2).toLowerCase();
        }
        if (linkPath != null) {
            if (linkPath.startsWith("http")) {
                return new Link(linkTitle, linkPath);
            }
            return Link.parseResourceLink(linkTitle, linkPath);
        }
        return null;
    }

    private static Link parseResourceLink(String title, String path) throws Exception {
        String[] components;
        Pattern pattern = Pattern.compile("^((\\w+):)?\\/?(.*)", 32);
        String protocal = null;
        String language = null;
        String project = null;
        String resource = null;
        String chapter = null;
        String chunk = null;
        String lastChunk = null;
        String arguments = null;
        Matcher m = pattern.matcher(path);
        if (m.find()) {
            protocal = m.group(2);
            path = m.group(3);
        }
        if ((components = path.split("\\/")).length == 1) {
            arguments = components[0];
        }
        if (components.length > 1) {
            language = components[0];
            project = components[1];
        }
        if (components.length > 2) {
            language = components[0];
            project = components[1];
            resource = components[2];
            if (resource.contains(":")) {
                arguments = resource;
                resource = null;
            }
        }
        if (components.length > 3) {
            language = components[0];
            project = components[1];
            resource = components[2];
            arguments = components[3];
            for (int i = 4; i < components.length - 1; ++i) {
                arguments = arguments + "/" + components[i];
            }
        }
        chapter = arguments;
        if (arguments != null && arguments.contains(":")) {
            String[] bits = arguments.split(":");
            chapter = bits[0];
            chunk = bits[1];
        }
        if (chunk != null && chunk.contains("-")) {
            String[] bits = chunk.split("-");
            chunk = bits[0];
            lastChunk = bits[1];
        }
        if (resource == null && project != null) {
            resource = project;
        }
        protocal = Link.nullEmpty(protocal);
        title = Link.nullEmpty(title);
        language = Link.nullEmpty(language);
        project = Link.nullEmpty(project);
        resource = Link.nullEmpty(resource);
        arguments = Link.nullEmpty(arguments);
        chapter = Link.nullEmpty(chapter);
        chunk = Link.nullEmpty(chunk);
        lastChunk = Link.nullEmpty(lastChunk);
        if (chunk != null && chunk.contains(",") || lastChunk != null && lastChunk.contains(",")) {
            throw new Exception("Invalid passage link " + path);
        }
        if (project != null && resource != null || arguments != null) {
            return new Link(protocal, title, language, project, resource, arguments, chapter, chunk, lastChunk);
        }
        return null;
    }

    private static String nullEmpty(String value) {
        if (value != null && value.isEmpty()) {
            return null;
        }
        return value;
    }

    public static List<Link> findLinks(CharSequence text) {
        return null;
    }
}

