/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.resourcecontainer;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

class FileUtil {
    FileUtil() {
    }

    public static String readStreamToString(InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file) throws IOException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            String contents = FileUtil.readStreamToString(fis);
            fis.close();
            String string = contents;
            return string;
        }
    }

    public static void writeStringToFile(File file, String contents) throws IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file.getAbsolutePath());
            fos.write(contents.getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInputStreamToFile(InputStream source, File destination) throws IOException {
        try {
            FileOutputStream output = FileUtil.openOutputStream(destination);
            try {
                FileUtil.copy(source, output);
                output.close();
            }
            finally {
                FileUtil.closeQuietly(output);
            }
        }
        finally {
            FileUtil.closeQuietly(source);
        }
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return FileUtil.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = FileUtil.copyLarge(input, output);
        return count > Integer.MAX_VALUE ? -1 : (int)count;
    }

    public static String getExtension(String path) {
        int index = path.lastIndexOf(".");
        if (index == -1 || index == path.length() - 1) {
            return "";
        }
        return path.substring(index + 1);
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return FileUtil.copyLarge(input, output, new byte[4096]);
    }

    public static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n1;
        long count = 0L;
        boolean n = false;
        while (-1 != (n1 = input.read(buffer))) {
            output.write(buffer, 0, n1);
            count += (long)n1;
        }
        return count;
    }

    public static boolean deleteQuietly(File fileOrDirectory) {
        if (fileOrDirectory != null) {
            if (fileOrDirectory.isDirectory()) {
                for (File child : fileOrDirectory.listFiles()) {
                    if (FileUtil.deleteQuietly(child)) continue;
                    return false;
                }
            }
            if (fileOrDirectory.exists()) {
                try {
                    fileOrDirectory.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean moveOrCopyQuietly(File sourceFile, File destFile) {
        if (sourceFile.exists() && !sourceFile.renameTo(destFile)) {
            try {
                if (sourceFile.isDirectory()) {
                    FileUtil.copyDirectory(sourceFile, destFile, null);
                } else {
                    FileUtil.copyFile(sourceFile, destFile);
                }
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void safeDelete(File file) {
        if (file != null && file.exists()) {
            File temp = new File(file.getParentFile(), System.currentTimeMillis() + ".trash");
            file.renameTo(temp);
            if (file.isDirectory()) {
                FileUtil.moveOrCopyQuietly(file, new File(temp, file.getName()));
            } else {
                FileUtil.moveOrCopyQuietly(file, temp);
            }
            FileUtil.deleteQuietly(file);
            FileUtil.deleteQuietly(temp);
        }
    }

    public static void copyDirectory(File srcDir, File destDir, FileFilter filter) throws IOException {
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcDir.exists()) {
            throw new FileNotFoundException("Source '" + srcDir + "' does not exist");
        }
        if (!srcDir.isDirectory()) {
            throw new IOException("Source '" + srcDir + "' exists but is not a directory");
        }
        if (srcDir.getCanonicalPath().equals(destDir.getCanonicalPath())) {
            throw new IOException("Source '" + srcDir + "' and destination '" + destDir + "' are the same");
        }
        ArrayList<String> exclusionList = null;
        if (destDir.getCanonicalPath().startsWith(srcDir.getCanonicalPath())) {
            File[] srcFiles;
            File[] fileArray = srcFiles = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
            if (srcFiles != null && srcFiles.length > 0) {
                exclusionList = new ArrayList<String>(srcFiles.length);
                File[] arr$ = srcFiles;
                int len$ = srcFiles.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    File srcFile = arr$[i$];
                    File copiedFile = new File(destDir, srcFile.getName());
                    exclusionList.add(copiedFile.getCanonicalPath());
                }
            }
        }
        FileUtil.doCopyDirectory(srcDir, destDir, filter, exclusionList);
    }

    private static void doCopyDirectory(File srcDir, File destDir, FileFilter filter, List<String> exclusionList) throws IOException {
        File[] srcFiles;
        File[] fileArray = srcFiles = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
        if (srcFiles == null) {
            throw new IOException("Failed to list contents of " + srcDir);
        }
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + destDir + "' exists but is not a directory");
            }
        } else if (!destDir.mkdirs() && !destDir.isDirectory()) {
            throw new IOException("Destination '" + destDir + "' directory cannot be created");
        }
        if (!destDir.canWrite()) {
            throw new IOException("Destination '" + destDir + "' cannot be written to");
        }
        File[] arr$ = srcFiles;
        int len$ = srcFiles.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            File srcFile = arr$[i$];
            File dstFile = new File(destDir, srcFile.getName());
            if (exclusionList != null && exclusionList.contains(srcFile.getCanonicalPath())) continue;
            if (srcFile.isDirectory()) {
                FileUtil.doCopyDirectory(srcFile, dstFile, filter, exclusionList);
                continue;
            }
            FileUtil.doCopyFile(srcFile, dstFile);
        }
        destDir.setLastModified(srcDir.lastModified());
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destFile == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Source '" + srcFile + "' does not exist");
        }
        if (srcFile.isDirectory()) {
            throw new IOException("Source '" + srcFile + "' exists but is a directory");
        }
        if (srcFile.getCanonicalPath().equals(destFile.getCanonicalPath())) {
            throw new IOException("Source '" + srcFile + "' and destination '" + destFile + "' are the same");
        }
        File parentFile = destFile.getParentFile();
        if (parentFile != null && !parentFile.mkdirs() && !parentFile.isDirectory()) {
            throw new IOException("Destination '" + parentFile + "' directory cannot be created");
        }
        if (destFile.exists() && !destFile.canWrite()) {
            throw new IOException("Destination '" + destFile + "' exists but is read-only");
        }
        FileUtil.doCopyFile(srcFile, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File srcFile, File destFile) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel input = null;
        FileChannel output = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = input.size();
            long count = 0L;
            for (long pos = 0L; pos < size; pos += output.transferFrom(input, pos, count)) {
                count = size - pos > 0x1E00000L ? 0x1E00000L : size - pos;
            }
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietly(output);
            FileUtil.closeQuietly(fos);
            FileUtil.closeQuietly(input);
            FileUtil.closeQuietly(fis);
            throw throwable;
        }
        FileUtil.closeQuietly(output);
        FileUtil.closeQuietly(fos);
        FileUtil.closeQuietly(input);
        FileUtil.closeQuietly(fis);
        if (srcFile.length() != destFile.length()) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
        }
        destFile.setLastModified(srcFile.lastModified());
    }

    public static void closeQuietly(Closeable closable) {
        try {
            closable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void forceMkdir(File directory) throws IOException {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                String message = "File " + directory + " exists and is " + "not a directory. Unable to create directory.";
                throw new IOException(message);
            }
        } else if (!directory.mkdirs() && !directory.isDirectory()) {
            String message = "Unable to create directory " + directory;
            throw new IOException(message);
        }
    }
}

