/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.resourcecontainer.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.kamranzafar.jtar.TarEntry;
import org.kamranzafar.jtar.TarInputStream;
import org.kamranzafar.jtar.TarOutputStream;

public class TarUtil {
    public static void untar(TarInputStream in, String destFolder) throws IOException {
        TarEntry entry;
        BufferedOutputStream dest = null;
        while ((entry = in.getNextEntry()) != null) {
            int count;
            System.out.println("Extracting: " + entry.getName());
            byte[] data = new byte[2048];
            if (entry.isDirectory()) {
                new File(destFolder + "/" + entry.getName()).mkdirs();
                continue;
            }
            int di = entry.getName().lastIndexOf(47);
            if (di != -1) {
                new File(destFolder + "/" + entry.getName().substring(0, di)).mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(destFolder + "/" + entry.getName());
            dest = new BufferedOutputStream(fos);
            while ((count = in.read(data)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
        }
    }

    public static void tar(String parent, String path, TarOutputStream out) throws IOException {
        BufferedInputStream origin = null;
        File f = new File(path);
        String[] files = f.list();
        if (files == null) {
            files = new String[]{f.getName()};
        }
        parent = parent == null ? "" : parent + f.getName() + "/";
        for (int i = 0; i < files.length; ++i) {
            int count;
            TarEntry entry;
            System.out.println("Adding: " + parent + files[i]);
            File fe = f;
            byte[] data = new byte[2048];
            if (f.isDirectory()) {
                fe = new File(f, files[i]);
            }
            if (fe.isDirectory()) {
                String[] fl = fe.list();
                if (fl != null && fl.length != 0) {
                    TarUtil.tar(parent, fe.getPath(), out);
                    continue;
                }
                entry = new TarEntry(fe, parent + files[i] + "/");
                out.putNextEntry(entry);
                continue;
            }
            FileInputStream fi = new FileInputStream(fe);
            origin = new BufferedInputStream(fi);
            entry = new TarEntry(fe, parent + files[i]);
            out.putNextEntry(entry);
            while ((count = origin.read(data)) != -1) {
                out.write(data, 0, count);
            }
            out.flush();
            origin.close();
        }
    }
}

