/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.tools.logger;

import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unfoldingword.tools.logger.FileUtils;
import org.unfoldingword.tools.logger.GlobalExceptionHandler;
import org.unfoldingword.tools.logger.LogEntry;
import org.unfoldingword.tools.logger.LogLevel;

public class Logger {
    public static final String PATTERN = "(\\d+\\/\\d+\\/\\d+\\s+\\d+:\\d+\\s+[A|P]M)\\s+([A-Z|])\\/(((?!:).)*):(.*)";
    private final File mLogFile;
    private final LogLevel mMinLoggingLevel;
    private final long mMaxLogFileSize;
    private static Logger sInstance = new Logger(null, LogLevel.Info);
    private static final long DEFAULT_MAX_LOG_FILE_SIZE = 204800L;
    private File stacktraceDir = null;

    private Logger(File logFile, LogLevel minLogingLevel) {
        this.mLogFile = logFile;
        this.mMinLoggingLevel = minLogingLevel == null ? LogLevel.Info : minLogingLevel;
        this.mMaxLogFileSize = 204800L;
    }

    private Logger(File logFile, LogLevel minLogingLevel, long maxLogFileSize) {
        this.mLogFile = logFile;
        this.mMinLoggingLevel = minLogingLevel == null ? LogLevel.Info : minLogingLevel;
        this.mMaxLogFileSize = maxLogFileSize;
    }

    public static void registerGlobalExceptionHandler(File stacktraceDir) {
        if (!(Thread.getDefaultUncaughtExceptionHandler() instanceof GlobalExceptionHandler)) {
            Logger.sInstance.stacktraceDir = stacktraceDir;
            Thread.setDefaultUncaughtExceptionHandler(new GlobalExceptionHandler(stacktraceDir));
        }
    }

    public static File[] listStacktraces() {
        if (Logger.sInstance.stacktraceDir != null) {
            return GlobalExceptionHandler.getStacktraces(Logger.sInstance.stacktraceDir);
        }
        return new File[0];
    }

    public static void configure(File logFile, LogLevel minLogingLevel) {
        sInstance = new Logger(logFile, minLogingLevel);
    }

    public static void configure(File logFile, LogLevel minLogingLevel, long maxLogFileSize) {
        sInstance = new Logger(logFile, minLogingLevel, maxLogFileSize);
    }

    public static void e(String logMessageTag, String logMessage) {
        try {
            int logResult = Log.e((String)logMessageTag, (String)logMessage);
            if (logResult > 0) {
                sInstance.logToFile(LogLevel.Error, logMessageTag, logMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void w(String logMessageTag, String logMessage) {
        try {
            int logResult = Log.w((String)logMessageTag, (String)logMessage);
            if (logResult > 0) {
                sInstance.logToFile(LogLevel.Warning, logMessageTag, logMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void i(String logMessageTag, String logMessage) {
        try {
            int logResult = Log.i((String)logMessageTag, (String)logMessage);
            if (logResult > 0) {
                sInstance.logToFile(LogLevel.Info, logMessageTag, logMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void e(String logMessageTag, String logMessage, Throwable throwableException) {
        try {
            int logResult = Log.e((String)logMessageTag, (String)logMessage, (Throwable)throwableException);
            if (logResult > 0) {
                sInstance.logToFile(LogLevel.Error, logMessageTag, logMessage + "\r\n" + Log.getStackTraceString((Throwable)throwableException));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void w(String logMessageTag, String logMessage, Throwable throwableException) {
        try {
            int logResult = Log.w((String)logMessageTag, (String)logMessage, (Throwable)throwableException);
            if (logResult > 0) {
                sInstance.logToFile(LogLevel.Warning, logMessageTag, logMessage + "\r\n" + Log.getStackTraceString((Throwable)throwableException));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void flush() {
        if (Logger.sInstance.mLogFile != null) {
            Logger.sInstance.mLogFile.delete();
        } else {
            Log.w((String)Logger.class.getName(), (String)"The log file has not been configured and cannot be deleted");
        }
    }

    private static String getDateTimeStamp() {
        Date dateNow = Calendar.getInstance().getTime();
        return DateFormat.getDateTimeInstance(3, 3, Locale.ENGLISH).format(dateNow);
    }

    private void logToFile(LogLevel level, String logMessageTag, String logMessage) {
        if (level.getIndex() >= this.mMinLoggingLevel.getIndex() && this.mLogFile != null) {
            try {
                if (!this.mLogFile.exists()) {
                    this.mLogFile.getParentFile().mkdirs();
                    this.mLogFile.createNewFile();
                }
                String log = FileUtils.readFileToString(this.mLogFile);
                log = String.format("%1s %2s/%3s: %4s\r\n%5s", Logger.getDateTimeStamp(), level.getLabel(), logMessageTag, logMessage, log);
                this.mLogFile.delete();
                FileUtils.writeStringToFile(this.mLogFile, log);
                if (this.mLogFile.length() > this.mMaxLogFileSize) {
                    FileChannel outChan = new FileOutputStream(this.mLogFile, true).getChannel();
                    outChan.truncate(this.mMaxLogFileSize * 0L);
                    outChan.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File getLogFile() {
        return Logger.sInstance.mLogFile;
    }

    public static List<LogEntry> getLogEntries() {
        ArrayList<LogEntry> logs = new ArrayList<LogEntry>();
        if (Logger.sInstance.mLogFile != null) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(Logger.sInstance.mLogFile)));
                StringBuilder sb = new StringBuilder();
                Pattern pattern = Pattern.compile(PATTERN);
                LogEntry log = null;
                while ((line = br.readLine()) != null && !Thread.interrupted()) {
                    Matcher match = pattern.matcher(line);
                    if (match.find()) {
                        if (log != null) {
                            log.setDetails(sb.toString().trim());
                            logs.add(log);
                            sb.setLength(0);
                        }
                        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yy hh:mm a");
                        log = new LogEntry(format.parse(match.group(1)), LogLevel.getLevel(match.group(2)), match.group(3), match.group(5));
                        continue;
                    }
                    sb.append(line);
                }
                if (log != null) {
                    log.setDetails(sb.toString().trim());
                    logs.add(log);
                    sb.setLength(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Log.w((String)Logger.class.getName(), (String)"The log file has not been configured and cannot be read");
        }
        return logs;
    }
}

