/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.tools.logger;

import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unfoldingword.tools.logger.FileUtils;
import org.unfoldingword.tools.logger.GlobalExceptionHandler;

public class Logger {
    public static final String PATTERN = "(\\d+\\/\\d+\\/\\d+\\s+\\d+:\\d+\\s+[A|P]M)\\s+([A-Z|])\\/(((?!:).)*):(.*)";
    private final File mLogFile;
    private final Level mMinLoggingLevel;
    private final long mMaxLogFileSize;
    private static Logger sInstance = new Logger(null, Level.Info);
    private static final long DEFAULT_MAX_LOG_FILE_SIZE = 204800L;
    private File stacktraceDir = null;

    private Logger(File logFile, Level minLogingLevel) {
        this.mLogFile = logFile;
        this.mMinLoggingLevel = minLogingLevel == null ? Level.Info : minLogingLevel;
        this.mMaxLogFileSize = 204800L;
    }

    private Logger(File logFile, Level minLogingLevel, long maxLogFileSize) {
        this.mLogFile = logFile;
        this.mMinLoggingLevel = minLogingLevel == null ? Level.Info : minLogingLevel;
        this.mMaxLogFileSize = maxLogFileSize;
    }

    public static void registerGlobalExceptionHandler(File stacktraceDir) {
        if (!(Thread.getDefaultUncaughtExceptionHandler() instanceof GlobalExceptionHandler)) {
            Logger.sInstance.stacktraceDir = stacktraceDir;
            Thread.setDefaultUncaughtExceptionHandler(new GlobalExceptionHandler(stacktraceDir));
        }
    }

    public static String[] listStacktraces() {
        if (Logger.sInstance.stacktraceDir != null) {
            return GlobalExceptionHandler.getStacktraces(Logger.sInstance.stacktraceDir);
        }
        return new String[0];
    }

    public static void configure(File logFile, Level minLogingLevel) {
        sInstance = new Logger(logFile, minLogingLevel);
    }

    public static void configure(File logFile, Level minLogingLevel, long maxLogFileSize) {
        sInstance = new Logger(logFile, minLogingLevel, maxLogFileSize);
    }

    public static void e(String logMessageTag, String logMessage) {
        try {
            int logResult = Log.e((String)logMessageTag, (String)logMessage);
            if (logResult > 0) {
                sInstance.logToFile(Level.Error, logMessageTag, logMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void w(String logMessageTag, String logMessage) {
        try {
            int logResult = Log.w((String)logMessageTag, (String)logMessage);
            if (logResult > 0) {
                sInstance.logToFile(Level.Warning, logMessageTag, logMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void i(String logMessageTag, String logMessage) {
        try {
            int logResult = Log.i((String)logMessageTag, (String)logMessage);
            if (logResult > 0) {
                sInstance.logToFile(Level.Info, logMessageTag, logMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void e(String logMessageTag, String logMessage, Throwable throwableException) {
        try {
            int logResult = Log.e((String)logMessageTag, (String)logMessage, (Throwable)throwableException);
            if (logResult > 0) {
                sInstance.logToFile(Level.Error, logMessageTag, logMessage + "\r\n" + Log.getStackTraceString((Throwable)throwableException));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void w(String logMessageTag, String logMessage, Throwable throwableException) {
        try {
            int logResult = Log.w((String)logMessageTag, (String)logMessage, (Throwable)throwableException);
            if (logResult > 0) {
                sInstance.logToFile(Level.Warning, logMessageTag, logMessage + "\r\n" + Log.getStackTraceString((Throwable)throwableException));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void flush() {
        if (Logger.sInstance.mLogFile != null) {
            Logger.sInstance.mLogFile.delete();
        } else {
            Log.w((String)Logger.class.getName(), (String)"The log file has not been configured and cannot be deleted");
        }
    }

    private static String getDateTimeStamp() {
        Date dateNow = Calendar.getInstance().getTime();
        return DateFormat.getDateTimeInstance(3, 3, Locale.ENGLISH).format(dateNow);
    }

    private void logToFile(Level level, String logMessageTag, String logMessage) {
        if (level.getIndex() >= this.mMinLoggingLevel.getIndex() && this.mLogFile != null) {
            try {
                if (!this.mLogFile.exists()) {
                    this.mLogFile.getParentFile().mkdirs();
                    this.mLogFile.createNewFile();
                }
                String log = FileUtils.readFileToString(this.mLogFile);
                log = String.format("%1s %2s/%3s: %4s\r\n%5s", Logger.getDateTimeStamp(), level.getLabel(), logMessageTag, logMessage, log);
                this.mLogFile.delete();
                FileUtils.writeStringToFile(this.mLogFile, log);
                if (this.mLogFile.length() > this.mMaxLogFileSize) {
                    FileChannel outChan = new FileOutputStream(this.mLogFile, true).getChannel();
                    outChan.truncate(this.mMaxLogFileSize * 0L);
                    outChan.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File getLogFile() {
        return Logger.sInstance.mLogFile;
    }

    public static List<Entry> getLogEntries() {
        ArrayList<Entry> logs = new ArrayList<Entry>();
        if (Logger.sInstance.mLogFile != null) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(Logger.sInstance.mLogFile)));
                StringBuilder sb = new StringBuilder();
                Pattern pattern = Pattern.compile(PATTERN);
                Entry log = null;
                while ((line = br.readLine()) != null && !Thread.interrupted()) {
                    Matcher match = pattern.matcher(line);
                    if (match.find()) {
                        if (log != null) {
                            log.setDetails(sb.toString().trim());
                            logs.add(log);
                            sb.setLength(0);
                        }
                        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yy hh:mm a");
                        log = new Entry(format.parse(match.group(1)), Level.getLevel(match.group(2)), match.group(3), match.group(5));
                        continue;
                    }
                    sb.append(line);
                }
                if (log != null) {
                    log.setDetails(sb.toString().trim());
                    logs.add(log);
                    sb.setLength(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Log.w((String)Logger.class.getName(), (String)"The log file has not been configured and cannot be read");
        }
        return logs;
    }

    public static class Entry {
        public final Date date;
        public final Level level;
        public final String classPath;
        public final String message;
        private String mDetails;

        public Entry(Date date, Level level, String classPath, String message) {
            this.date = date;
            this.level = level;
            this.classPath = classPath;
            this.message = message;
        }

        public Entry(Date date, Level level, String classPath, String message, String details) {
            this.date = date;
            this.level = level;
            this.classPath = classPath;
            this.message = message;
            this.mDetails = details;
        }

        public void setDetails(String details) {
            this.mDetails = details;
        }

        public String getDetails() {
            return this.mDetails;
        }
    }

    public static enum Level {
        Info(0, "I"),
        Warning(1, "W"),
        Error(2, "E");

        private int level;
        private String label;

        private Level(int i, String label) {
            this.level = i;
            this.label = label;
        }

        public int getIndex() {
            return this.level;
        }

        public String getLabel() {
            return this.label;
        }

        public static Level getLevel(String label) {
            for (Level l : Level.values()) {
                if (!l.getLabel().toLowerCase().equals(label.toLowerCase())) continue;
                return l;
            }
            return null;
        }

        public static Level getLevel(int index) {
            for (Level l : Level.values()) {
                if (l.getIndex() != index) continue;
                return l;
            }
            return null;
        }
    }
}

