/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.tools.logger;

import android.os.Process;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.StringWriter;

public class GlobalExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final String STACKTRACE_EXT = "stacktrace";
    private Thread.UncaughtExceptionHandler defaultUEH;
    private final String mStracktraceDir;

    public GlobalExceptionHandler(File stacktraceDir) {
        if (!stacktraceDir.exists()) {
            stacktraceDir.mkdirs();
        }
        this.mStracktraceDir = stacktraceDir.getAbsolutePath();
        this.defaultUEH = Thread.getDefaultUncaughtExceptionHandler();
    }

    public static String[] getStacktraces(File stacktraceDir) {
        String[] files = stacktraceDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                String[] pieces = filename.split("\\.");
                String ext = pieces[pieces.length - 1];
                return new File(dir, filename).isFile() && ext.equals(GlobalExceptionHandler.STACKTRACE_EXT);
            }
        });
        if (files != null) {
            String[] stacktraces = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                stacktraces[i] = new File(stacktraceDir, files[i]).getAbsolutePath();
            }
            return stacktraces;
        }
        return new String[0];
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Long tsLong = System.currentTimeMillis();
        String timestamp = tsLong.toString();
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        e.printStackTrace(printWriter);
        String stacktrace = ((Object)result).toString();
        printWriter.close();
        String filename = timestamp + "." + STACKTRACE_EXT;
        if (this.mStracktraceDir != null) {
            this.writeToFile(stacktrace, filename);
        }
        this.defaultUEH.uncaughtException(t, e);
        Process.killProcess((int)Process.myPid());
        System.exit(0);
    }

    public void writeToFile(String stacktrace, String filename) {
        try {
            BufferedWriter bos = new BufferedWriter(new FileWriter(this.mStracktraceDir + "/" + filename));
            bos.write(stacktrace);
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

