package org.unfoldingword.tools.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Impliments a put request
 */
public class PutRequest extends Request {
    private final String data;

    /**
     * Creates a new put request
     * @param url the url receiving the put request
     * @param data the put data
     */
    public PutRequest(URL url, String data) {
        super(url, "PUT");
        this.data = data;
    }

    @Override
    protected void onConnected(HttpURLConnection conn) throws IOException {
        writeData(conn, data);
    }
}
