/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.tools.foreground;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Foreground
implements Application.ActivityLifecycleCallbacks {
    private static long checkDelay = 500L;
    private static final String TAG = Foreground.class.getName();
    private static Foreground instance;
    private int counter = 0;
    private boolean foreground = false;
    private Handler handler = new Handler();
    private Runnable check;
    private List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void setDelay(long delay) {
        checkDelay = delay;
    }

    public static Foreground init(Application app) {
        if (instance == null) {
            instance = new Foreground();
            app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance);
        }
        return instance;
    }

    public static Foreground get(Application app) {
        return Foreground.init(app);
    }

    public static Foreground get(Context c) {
        if (instance == null) {
            Context appContext = c.getApplicationContext();
            if (appContext instanceof Application) {
                Foreground.init((Application)appContext);
            }
            throw new IllegalStateException("Foreground is not initialised and cannot obtain the Application object");
        }
        return instance;
    }

    public static Foreground get() {
        if (instance == null) {
            throw new IllegalStateException("Foreground is not initialised - invoke at least once with parameterised init/get");
        }
        return instance;
    }

    private Foreground() {
    }

    public boolean isForeground() {
        return this.counter > 0;
    }

    public boolean isBackground() {
        return this.counter <= 0;
    }

    public void onActivityStarted(Activity activity) {
        ++this.counter;
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        if (!this.foreground && this.counter > 0) {
            this.foreground = true;
            Log.i((String)TAG, (String)"went foreground");
            for (Listener l : this.listeners) {
                try {
                    l.onBecameForeground();
                }
                catch (Exception e) {
                    Log.e((String)"Foreground", (String)"Listener threw exception", (Throwable)e);
                }
            }
        }
    }

    public void onActivityStopped(Activity activity) {
        --this.counter;
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        this.check = new Runnable(){

            @Override
            public void run() {
                if (Foreground.this.foreground && Foreground.this.counter <= 0) {
                    Foreground.this.foreground = false;
                    Log.i((String)TAG, (String)"went background");
                    for (Listener l : Foreground.this.listeners) {
                        try {
                            l.onBecameBackground();
                        }
                        catch (Exception e) {
                            Log.e((String)"Foreground", (String)"Listener threw exception", (Throwable)e);
                        }
                    }
                }
            }
        };
        this.handler.postDelayed(this.check, checkDelay);
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public static interface Listener {
        public void onBecameForeground();

        public void onBecameBackground();
    }
}

