/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.door43client.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.unfoldingword.door43client.models.DatabaseObject;

public class Resource
extends DatabaseObject {
    public final String slug;
    public final String name;
    public final String type;
    public final Map<String, Object> status;
    public final List<Format> formats = new ArrayList<Format>();
    public final String wordsAssignmentsUrl;

    public Resource(String slug, String name, String type, String wordsAssignmentsUrl, Map status) {
        this.slug = slug;
        this.name = name;
        this.type = type;
        this.status = status;
        this.wordsAssignmentsUrl = wordsAssignmentsUrl;
    }

    public void addFormat(Format format) {
        this.formats.add(format);
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("slug", (Object)this.slug);
        json.put("name", (Object)this.name);
        json.put("type", (Object)this.type);
        JSONObject statusJson = new JSONObject();
        statusJson.put("translate_mode", this.status.get("translate_mode"));
        statusJson.put("checking_level", this.status.get("checking_level"));
        statusJson.put("license", this.status.get("license"));
        statusJson.put("version", this.status.get("version"));
        statusJson.put("pub_date", this.status.get("pub_date"));
        statusJson.put("comments", this.status.get("comments"));
        json.put("status", (Object)statusJson);
        return json;
    }

    public static class Format {
        public int packageVersion;
        public String mimeType;
        public int modifiedAt;
        public String url;

        public Format(int packageVersion, String mimeType, int modifiedAt, String url) {
            this.packageVersion = packageVersion;
            this.mimeType = mimeType;
            this.modifiedAt = modifiedAt;
            this.url = url;
        }
    }
}

