/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.door43client;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;

class SQLiteHelper
extends SQLiteOpenHelper {
    private static final int DATABASE_VERSION = 1;
    private final String schema;
    private final String name;

    public SQLiteHelper(Context context, String schema, String name) {
        super(context, name, null, 1);
        this.schema = schema;
        this.name = name;
    }

    public void onCreate(SQLiteDatabase db) {
        String[] queries;
        if (Build.VERSION.SDK_INT < 16) {
            db.execSQL("PRAGMA foreign_keys=OFF;");
        } else {
            db.setForeignKeyConstraintsEnabled(false);
        }
        for (String query : queries = this.schema.split(";")) {
            if ((query = query.trim()).isEmpty()) continue;
            try {
                db.execSQL(query);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onConfigure(SQLiteDatabase db) {
        if (Build.VERSION.SDK_INT >= 16) {
            db.setForeignKeyConstraintsEnabled(false);
        } else {
            db.execSQL("PRAGMA foreign_keys=OFF;");
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (newVersion == 1) {
            this.onCreate(db);
        }
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVesrion) {
        this.onCreate(db);
    }

    public void onOpen(SQLiteDatabase db) {
        if (Build.VERSION.SDK_INT >= 16) {
            db.setForeignKeyConstraintsEnabled(true);
        } else {
            db.execSQL("PRAGMA foreign_keys=ON;");
        }
    }
}

