/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.door43client;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unfoldingword.door43client.Index;
import org.unfoldingword.door43client.SQLiteHelper;
import org.unfoldingword.door43client.models.Catalog;
import org.unfoldingword.door43client.models.Category;
import org.unfoldingword.door43client.models.CategoryEntry;
import org.unfoldingword.door43client.models.ChunkMarker;
import org.unfoldingword.door43client.models.Project;
import org.unfoldingword.door43client.models.Question;
import org.unfoldingword.door43client.models.Questionnaire;
import org.unfoldingword.door43client.models.Resource;
import org.unfoldingword.door43client.models.SourceLanguage;
import org.unfoldingword.door43client.models.TargetLanguage;
import org.unfoldingword.door43client.models.Versification;

class Library
implements Index {
    private final SQLiteHelper sqliteHelper;
    private final SQLiteDatabase db;

    public Library(SQLiteHelper sqliteHelper) {
        this.sqliteHelper = sqliteHelper;
        this.db = sqliteHelper.getWritableDatabase();
    }

    public void beginTransaction() {
        this.db.beginTransactionNonExclusive();
    }

    public void endTransaction(boolean success) {
        if (success) {
            this.db.setTransactionSuccessful();
        }
        this.db.endTransaction();
    }

    public void closeDatabase() {
        this.db.close();
    }

    private void validateNotEmpty(String value) throws Exception {
        if (value == null || value.trim().isEmpty()) {
            throw new Exception("Invalid parameter value");
        }
    }

    private String deNull(String value) {
        return value == null ? "" : value;
    }

    private long insertOrIgnore(String table, ContentValues values, String[] uniqueColumns) {
        SQLException error = null;
        try {
            return this.db.insertOrThrow(table, null, values);
        }
        catch (SQLException e) {
            error = e;
            WhereClause where = WhereClause.prepare(values, uniqueColumns);
            Cursor cursor = this.db.rawQuery("select id from " + table + " where " + where.statement, where.arguments);
            if (cursor.moveToFirst()) {
                long id = cursor.getLong(0);
                cursor.close();
                return id;
            }
            cursor.close();
            if (error != null) {
                error.printStackTrace();
            }
            return -1L;
        }
    }

    private long insertOrUpdate(String table, ContentValues values, String[] uniqueColumns) throws Exception {
        long id = this.insertOrIgnore(table, values, uniqueColumns);
        if (id == -1L) {
            WhereClause where = WhereClause.prepare(values, uniqueColumns);
            for (String key : uniqueColumns) {
                values.remove(key);
            }
            int numRows = this.db.updateWithOnConflict(table, values, where.statement, where.arguments, 1);
            if (numRows == 0) {
                throw new Exception("Failed to update the row in " + table);
            }
            Cursor cursor = this.db.rawQuery("select id from " + table + " where " + where.statement, where.arguments);
            if (cursor.moveToFirst()) {
                id = cursor.getLong(0);
                cursor.close();
            } else {
                cursor.close();
                throw new Exception("Failed to find the row in " + table);
            }
        }
        return id;
    }

    public long addSourceLanguage(SourceLanguage language) throws Exception {
        this.validateNotEmpty(language.slug);
        this.validateNotEmpty(language.name);
        this.validateNotEmpty(language.direction);
        ContentValues values = new ContentValues();
        values.put("slug", language.slug);
        values.put("name", language.name);
        values.put("direction", language.direction);
        return this.insertOrUpdate("source_language", values, new String[]{"slug"});
    }

    public boolean addTargetLanguage(TargetLanguage language) throws Exception {
        this.validateNotEmpty(language.slug);
        this.validateNotEmpty(language.name);
        this.validateNotEmpty(language.direction);
        ContentValues values = new ContentValues();
        values.put("slug", language.slug);
        values.put("name", language.name);
        values.put("direction", language.direction);
        values.put("anglicized_name", this.deNull(language.anglicizedName));
        values.put("region", this.deNull(language.region));
        values.put("is_gateway_language", Integer.valueOf(language.isGatewayLanguage ? 1 : 0));
        long id = this.insertOrUpdate("target_language", values, new String[]{"slug"});
        return id > 0L;
    }

    public boolean addTempTargetLanguage(TargetLanguage language) throws Exception {
        this.validateNotEmpty(language.slug);
        this.validateNotEmpty(language.name);
        this.validateNotEmpty(language.direction);
        ContentValues values = new ContentValues();
        values.put("slug", language.slug);
        values.put("name", language.name);
        values.put("direction", language.direction);
        values.put("anglicized_name", this.deNull(language.anglicizedName));
        values.put("region", this.deNull(language.region));
        values.put("is_gateway_language", Integer.valueOf(language.isGatewayLanguage ? 1 : 0));
        long id = this.insertOrUpdate("temp_target_language", values, new String[]{"slug"});
        return id > 0L;
    }

    public boolean setApprovedTargetLanguage(String tempTargetLanguageSlug, String targetLanguageSlug) throws Exception {
        this.validateNotEmpty(tempTargetLanguageSlug);
        this.validateNotEmpty(targetLanguageSlug);
        ContentValues contentValues = new ContentValues();
        contentValues.put("approved_target_language_slug", targetLanguageSlug);
        int rowsAffected = this.db.updateWithOnConflict("temp_target_language", contentValues, "slug=?", new String[]{tempTargetLanguageSlug}, 4);
        return rowsAffected > 0;
    }

    public long addProject(Project project, List<Category> categories, long sourceLanguageId) throws Exception {
        this.validateNotEmpty(project.slug);
        this.validateNotEmpty(project.name);
        long parentCategoryId = 0L;
        if (categories != null) {
            for (Category category : categories) {
                this.validateNotEmpty(category.slug);
                this.validateNotEmpty(category.name);
                ContentValues insertValues = new ContentValues();
                insertValues.put("slug", category.slug);
                insertValues.put("parent_id", Long.valueOf(parentCategoryId));
                long id = this.insertOrIgnore("category", insertValues, new String[]{"slug", "parent_id"});
                if (id <= 0L) {
                    throw new Exception("Invalid category");
                }
                parentCategoryId = id;
                ContentValues updateValues = new ContentValues();
                updateValues.put("source_language_id", Long.valueOf(sourceLanguageId));
                updateValues.put("category_id", Long.valueOf(parentCategoryId));
                updateValues.put("name", category.name);
                this.insertOrUpdate("category_name", updateValues, new String[]{"source_language_id", "category_id"});
            }
        }
        ContentValues updateProject = new ContentValues();
        updateProject.put("slug", project.slug);
        updateProject.put("name", project.name);
        updateProject.put("desc", this.deNull(project.description));
        updateProject.put("icon", this.deNull(project.icon));
        updateProject.put("sort", Integer.valueOf(project.sort));
        updateProject.put("chunks_url", this.deNull(project.chunksUrl));
        updateProject.put("source_language_id", Long.valueOf(sourceLanguageId));
        updateProject.put("category_id", Long.valueOf(parentCategoryId));
        return this.insertOrUpdate("project", updateProject, new String[]{"slug", "source_language_id"});
    }

    public long addVersification(Versification versification, long sourceLanguageId) throws Exception {
        this.validateNotEmpty(Versification.slug);
        this.validateNotEmpty(Versification.name);
        ContentValues values = new ContentValues();
        values.put("slug", Versification.slug);
        long versificationId = this.insertOrIgnore("versification", values, new String[]{"slug"});
        if (versificationId <= 0L) {
            throw new Exception("Invalid versification");
        }
        ContentValues cv = new ContentValues();
        cv.put("source_language_id", Long.valueOf(sourceLanguageId));
        cv.put("versification_id", Long.valueOf(versificationId));
        cv.put("name", Versification.name);
        this.insertOrUpdate("versification_name", cv, new String[]{"source_language_id", "versification_id"});
        return versificationId;
    }

    public long addChunkMarker(ChunkMarker chunk, String projectSlug, long versificationId) throws Exception {
        this.validateNotEmpty(ChunkMarker.chapter);
        this.validateNotEmpty(ChunkMarker.verse);
        this.validateNotEmpty(projectSlug);
        ContentValues chunkValues = new ContentValues();
        chunkValues.put("chapter", ChunkMarker.chapter);
        chunkValues.put("verse", ChunkMarker.verse);
        chunkValues.put("project_slug", projectSlug);
        chunkValues.put("versification_id", Long.valueOf(versificationId));
        long id = this.insertOrIgnore("chunk_marker", chunkValues, new String[]{"project_slug", "versification_id", "chapter", "verse"});
        if (id == -1L) {
            throw new Exception("Invalid Chunk Marker");
        }
        return id;
    }

    public long addCatalog(Catalog catalog) throws Exception {
        this.validateNotEmpty(catalog.slug);
        this.validateNotEmpty(catalog.url);
        ContentValues values = new ContentValues();
        values.put("slug", catalog.slug);
        values.put("url", catalog.url);
        values.put("modified_at", Integer.valueOf(catalog.modifiedAt));
        return this.insertOrUpdate("catalog", values, new String[]{"slug"});
    }

    public long addResource(Resource resource, long projectId) throws Exception {
        this.validateNotEmpty(resource.slug);
        this.validateNotEmpty(resource.name);
        this.validateNotEmpty(resource.type);
        this.validateNotEmpty(resource.formats.size() > 0 ? "good" : null);
        this.validateNotEmpty((String)resource.status.get("translate_mode"));
        this.validateNotEmpty((String)resource.status.get("checking_level"));
        this.validateNotEmpty((String)resource.status.get("version"));
        ContentValues values = new ContentValues();
        values.put("slug", resource.slug);
        values.put("name", resource.name);
        values.put("type", resource.type);
        values.put("translate_mode", (String)resource.status.get("translate_mode"));
        values.put("checking_level", (String)resource.status.get("checking_level"));
        values.put("comments", this.deNull((String)resource.status.get("comments")));
        values.put("pub_date", this.deNull((String)resource.status.get("pub_date")));
        values.put("license", this.deNull((String)resource.status.get("license")));
        values.put("version", (String)resource.status.get("version"));
        values.put("project_id", Long.valueOf(projectId));
        long resourceId = this.insertOrUpdate("resource", values, new String[]{"slug", "project_id"});
        for (Resource.Format format : resource.formats) {
            this.validateNotEmpty(format.mimeType);
            ContentValues formatValues = new ContentValues();
            formatValues.put("package_version", Integer.valueOf(format.packageVersion));
            formatValues.put("mime_type", format.mimeType);
            formatValues.put("modified_at", Integer.valueOf(format.modifiedAt));
            formatValues.put("url", this.deNull(format.url));
            formatValues.put("resource_id", Long.valueOf(resourceId));
            this.insertOrUpdate("resource_format", formatValues, new String[]{"mime_type", "resource_id"});
        }
        if (resource.wordsAssignmentsUrl != null && !resource.wordsAssignmentsUrl.equals("")) {
            ContentValues legacyValues = new ContentValues();
            legacyValues.put("translation_words_assignments_url", resource.wordsAssignmentsUrl);
            legacyValues.put("resource_id", Long.valueOf(resourceId));
            this.insertOrUpdate("legacy_resource_info", legacyValues, new String[]{"resource_id"});
        }
        return resourceId;
    }

    public long addQuestionnaire(Questionnaire questionnaire) throws Exception {
        this.validateNotEmpty(questionnaire.languageSlug);
        this.validateNotEmpty(questionnaire.languageName);
        this.validateNotEmpty(questionnaire.languageDirection);
        ContentValues values = new ContentValues();
        values.put("language_slug", questionnaire.languageSlug);
        values.put("language_name", questionnaire.languageName);
        values.put("language_direction", questionnaire.languageDirection);
        values.put("td_id", Long.valueOf(questionnaire.tdId));
        return this.insertOrUpdate("questionnaire", values, new String[]{"td_id", "language_slug"});
    }

    public long addQuestion(Question question, long questionnaireId) throws Exception {
        this.validateNotEmpty(question.text);
        this.validateNotEmpty(question.inputType);
        ContentValues values = new ContentValues();
        values.put("text", question.text);
        values.put("help", this.deNull(question.help));
        values.put("is_required", Integer.valueOf(question.isRequired ? 1 : 0));
        values.put("input_type", question.inputType);
        values.put("sort", Integer.valueOf(question.sort));
        values.put("depends_on", Long.valueOf(question.dependsOn));
        values.put("td_id", Long.valueOf(question.tdId));
        values.put("questionnaire_id", Long.valueOf(questionnaireId));
        return this.insertOrUpdate("question", values, new String[]{"td_id", "questionnaire_id"});
    }

    @Override
    public List<HashMap> listSourceLanguagesLastModified() {
        Cursor cursor = this.db.rawQuery("select sl.slug, max(rf.modified_at) as modified_at from resource_format as rf left join resource  as r on r.id=rf.resource_id left join project as p on p.id=r.project_id left join source_language as sl on sl.id=p.source_language_id where rf.mime_type like(\"application/tsrc+%\") group by sl.slug", null);
        cursor.moveToFirst();
        ArrayList<HashMap> langsLastModifiedList = new ArrayList<HashMap>();
        while (!cursor.isAfterLast()) {
            CursorReader reader = new CursorReader(cursor);
            String slug = reader.getString("slug");
            int modifiedAt = reader.getInt("modified_at");
            HashMap<String, Integer> sourceLanguageMap = new HashMap<String, Integer>();
            sourceLanguageMap.put(slug, modifiedAt);
            langsLastModifiedList.add(sourceLanguageMap);
        }
        cursor.close();
        return langsLastModifiedList;
    }

    @Override
    public Map<String, Integer> listProjectsLastModified(String languageSlug) {
        Cursor cursor = null;
        cursor = languageSlug != null || languageSlug != "" ? this.db.rawQuery("select p.slug, max(rf.modified_at) as modified_at from resource_format as rf left join resource  as r on r.id=rf.resource_id left join project as p on p.id=r.project_id left join source_language as sl on sl.id=p.source_language_id where rf.mime_type like(\"application/tsrc+%\") and sl.slug=? group by p.slug", new String[]{languageSlug}) : this.db.rawQuery("select p.slug, max(rf.modified_at) as modified_at from resource_format as rf left join resource  as r on r.id=rf.resource_id left join project as p on p.id=r.project_id left join source_language as sl on sl.id=p.source_language_id where rf.mime_type like(\"application/tsrc+%\") and sl.slug=? group by p.slug", null);
        HashMap<String, Integer> projectsLastModifiedList = new HashMap<String, Integer>();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            CursorReader reader = new CursorReader(cursor);
            projectsLastModifiedList.put(reader.getString("slug"), reader.getInt("modified_at"));
            cursor.moveToNext();
        }
        cursor.close();
        return projectsLastModifiedList;
    }

    @Override
    public SourceLanguage getSourceLanguage(String sourceLanguageSlug) {
        Cursor cursor = this.db.rawQuery("select * from source_language where slug=? limit 1", new String[]{sourceLanguageSlug});
        if (cursor.moveToFirst()) {
            CursorReader reader = new CursorReader(cursor);
            String name = reader.getString("name");
            String direction = reader.getString("direction");
            SourceLanguage sourceLanguage = new SourceLanguage(sourceLanguageSlug, name, direction);
            sourceLanguage._dbInfo.rowId = reader.getLong("id");
            cursor.close();
            return sourceLanguage;
        }
        cursor.close();
        return null;
    }

    @Override
    public List<SourceLanguage> getSourceLanguages() {
        Cursor cursor = this.db.rawQuery("select * from source_language order by slug desc", null);
        ArrayList<SourceLanguage> sourceLanguages = new ArrayList<SourceLanguage>();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            CursorReader reader = new CursorReader(cursor);
            String slug = reader.getString("id");
            String name = reader.getString("name");
            String direction = reader.getString("direction");
            SourceLanguage sourceLanguage = new SourceLanguage(slug, name, direction);
            sourceLanguage._dbInfo.rowId = reader.getLong("id");
            sourceLanguages.add(sourceLanguage);
            cursor.moveToNext();
        }
        cursor.close();
        return sourceLanguages;
    }

    @Override
    public TargetLanguage getTargetLanguage(String targetLangaugeSlug) {
        Cursor cursor = this.db.rawQuery("select * from (  select slug, name, anglicized_name, direction, region, is_gateway_language from target_language  union  select slug, name, anglicized_name, direction, region, is_gateway_language from temp_target_language  where approved_target_language_slug is null) where slug=? limit 1", new String[]{targetLangaugeSlug});
        if (cursor.moveToFirst()) {
            CursorReader reader = new CursorReader(cursor);
            String name = reader.getString("name");
            String anglicized = reader.getString("anglicized_name");
            String direction = reader.getString("direction");
            String region = reader.getString("region");
            boolean isGateWay = reader.getBoolean("is_gateway_language");
            TargetLanguage dummyTargetLanguage = new TargetLanguage(targetLangaugeSlug, name, anglicized, direction, region, isGateWay);
            cursor.close();
            return dummyTargetLanguage;
        }
        cursor.close();
        return null;
    }

    @Override
    public List<TargetLanguage> getTargetLanguages() {
        Cursor cursor = this.db.rawQuery("select * from (  select slug, name, anglicized_name, direction, region, is_gateway_language from target_language  union  select slug, name, anglicized_name, direction, region, is_gateway_language from temp_target_language  where approved_target_language_slug is null) order by slug asc, name desc", null);
        ArrayList<TargetLanguage> languages = new ArrayList<TargetLanguage>();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            CursorReader reader = new CursorReader(cursor);
            String slug = reader.getString("slug");
            String name = reader.getString("name");
            String angName = reader.getString("anglicized_name");
            String dir = reader.getString("direction");
            String region = reader.getString("region");
            boolean isGate = reader.getBoolean("is_gateway_language");
            TargetLanguage newLang = new TargetLanguage(slug, name, angName, dir, region, isGate);
            languages.add(newLang);
            cursor.moveToNext();
        }
        cursor.close();
        return languages;
    }

    @Override
    public TargetLanguage getApprovedTargetLanguage(String tempTargetLanguageSlug) {
        TargetLanguage language = null;
        Cursor cursor = this.db.rawQuery("select tl.* from target_language as tl left join temp_target_language as ttl on ttl.approved_target_language_slug=tl.slug where ttl.slug=?", new String[]{tempTargetLanguageSlug});
        if (cursor.moveToFirst()) {
            CursorReader reader = new CursorReader(cursor);
            String approvedSlug = reader.getString("slug");
            String name = reader.getString("name");
            String angName = reader.getString("anglicized_name");
            String dir = reader.getString("direction");
            String region = reader.getString("region");
            boolean isGate = reader.getBoolean("is_gateway_language");
            language = new TargetLanguage(approvedSlug, name, angName, dir, region, isGate);
            cursor.close();
        }
        return language;
    }

    @Override
    public Project getProject(String sourceLanguageSlug, String projectSlug) {
        Project project = null;
        Cursor cursor = this.db.rawQuery("select * from project where slug=? and source_language_id in ( select id from source_language where slug=?) limit 1", new String[]{projectSlug, sourceLanguageSlug});
        if (cursor.moveToFirst()) {
            CursorReader reader = new CursorReader(cursor);
            String slug = reader.getString("slug");
            String name = reader.getString("name");
            String desc = reader.getString("desc");
            String icon = reader.getString("icon");
            int sort = reader.getInt("sort");
            String chunksUrl = reader.getString("chunks_url");
            project = new Project(slug, name, desc, icon, sort, chunksUrl);
            project._dbInfo.rowId = reader.getLong("id");
        }
        cursor.close();
        return project;
    }

    @Override
    public List<Project> getProjects(String sourceLanguageSlug) {
        Cursor cursor = this.db.rawQuery("select * from project where source_language_id in (select id from source_language where slug=?) order by sort asc", new String[]{sourceLanguageSlug});
        ArrayList<Project> projects = new ArrayList<Project>();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            CursorReader reader = new CursorReader(cursor);
            String slug = reader.getString("slug");
            String name = reader.getString("name");
            String desc = reader.getString("desc");
            String icon = reader.getString("icon");
            int sort = reader.getInt("sort");
            String chunksUrl = reader.getString("chunks_url");
            Project project = new Project(slug, name, desc, icon, sort, chunksUrl);
            project._dbInfo.rowId = reader.getLong("id");
            projects.add(project);
            cursor.moveToNext();
        }
        cursor.close();
        return projects;
    }

    @Override
    public List<CategoryEntry> getProjectCategories(long parentCategoryId, String languageSlug, String translateMode) {
        String[] preferredSlug = new String[]{languageSlug, "en", "%"};
        ArrayList<CategoryEntry> projectCategories = new ArrayList<CategoryEntry>();
        Cursor categoryCursor = translateMode != null && !translateMode.isEmpty() ? this.db.rawQuery("select 'category' as type, c.slug as name, '' as source_language_slug, c.id, c.slug, c.parent_id, count(p.id) as num from category as c left join (  select p.id, p.category_id, count(r.id) as num from project as p  left join resource as r on r.project_id=p.id and r.translate_mode like(?)  group by p.slug ) p on p.category_id=c.id and p.num > 0 where parent_id=" + parentCategoryId + " and num > 0 " + "group by c.slug", new String[]{translateMode}) : this.db.rawQuery("select 'category' as type, category.slug as name, '' as source_language_slug, * from category where parent_id=" + parentCategoryId, null);
        categoryCursor.moveToFirst();
        while (!categoryCursor.isAfterLast()) {
            String catSlug = categoryCursor.getString(categoryCursor.getColumnIndex("slug"));
            int catId = categoryCursor.getInt(categoryCursor.getColumnIndex("id"));
            for (String slug : preferredSlug) {
                Cursor cursor = this.db.rawQuery("select sl.slug as source_language_slug, cn.name as name from category_name as cn left join source_language as sl on sl.id=cn.source_language_id where sl.slug like(?) and cn.category_id=" + catId, new String[]{slug});
                if (cursor.moveToFirst()) {
                    CursorReader reader = new CursorReader(cursor);
                    String catName = reader.getString("name");
                    String catSourceLanguageSlug = reader.getString("source_language_slug");
                    CategoryEntry categoryEntry = new CategoryEntry(CategoryEntry.Type.CATEGORY, catId, catSlug, catName, catSourceLanguageSlug, parentCategoryId);
                    projectCategories.add(categoryEntry);
                }
                cursor.close();
            }
            categoryCursor.moveToNext();
        }
        categoryCursor.close();
        Cursor projectCursor = this.db.rawQuery("select * from ( select 'project' as type, '' as source_language_slug, p.id, p.slug, p.sort, p.name, count(r.id) as num from project as p left join resource as r on r.project_id=p.id and r.translate_mode like (?) where p.category_id=" + parentCategoryId + " group by p.slug)" + (!translateMode.isEmpty() ? " where num > 0" : ""), new String[]{!translateMode.isEmpty() ? translateMode : "%"});
        projectCursor.moveToFirst();
        while (!projectCursor.isAfterLast()) {
            String projectSlug = projectCursor.getString(projectCursor.getColumnIndex("slug"));
            long projectId = projectCursor.getLong(projectCursor.getColumnIndex("id"));
            for (String slug : preferredSlug) {
                Cursor cursor = this.db.rawQuery("select sl.slug as source_language_slug, p.name as name from project as p left join source_language as sl on sl.id=p.source_language_id where sl.slug like(?) and p.slug=? order by sl.slug asc", new String[]{slug, projectSlug});
                if (cursor.moveToFirst()) {
                    CursorReader reader = new CursorReader(cursor);
                    String projectName = reader.getString("name");
                    String projSourceLangSlug = reader.getString("source_language_slug");
                    CategoryEntry categoryEntry = new CategoryEntry(CategoryEntry.Type.PROJECT, projectId, projectSlug, projectName, projSourceLangSlug, parentCategoryId);
                    projectCategories.add(categoryEntry);
                }
                cursor.close();
            }
            projectCursor.moveToNext();
        }
        projectCursor.close();
        return projectCategories;
    }

    @Override
    public Resource getResource(String sourceLanguageSlug, String projectSlug, String resourceSlug) {
        Resource resource = null;
        Cursor cursor = this.db.rawQuery("select r.id, r.name, r.translate_mode, r.type, r.checking_level, r.comments, r.pub_date, r.license, r.version, lri.translation_words_assignments_url from resource as r left join legacy_resource_info as lri on lri.resource_id=r.id where r.slug=? and r.project_id in (  select id from project where slug=? and source_language_id in (  select id from source_language where slug=?) ) limit 1", new String[]{resourceSlug, projectSlug, sourceLanguageSlug});
        if (cursor.moveToFirst()) {
            CursorReader reader = new CursorReader(cursor);
            long resourceId = reader.getLong("id");
            String name = reader.getString("name");
            String translateMode = reader.getString("translate_mode");
            String type = reader.getString("type");
            String checkingLevel = reader.getString("checking_level");
            String comments = reader.getString("comments");
            String pubDate = reader.getString("pub_date");
            String license = reader.getString("license");
            String version = reader.getString("version");
            String wordsAssignmentsUrl = reader.getString("translation_words_assignments_url");
            HashMap<String, String> status = new HashMap<String, String>();
            status.put("translateMode", translateMode);
            status.put("checkingLevel", checkingLevel);
            status.put("comments", comments);
            status.put("pub_date", pubDate);
            status.put("license", license);
            status.put("version", version);
            resource = new Resource(resourceSlug, name, type, wordsAssignmentsUrl, status);
            Cursor formatCursor = this.db.rawQuery("select * from resource_format where resource_id=" + resourceId, null);
            formatCursor.moveToFirst();
            while (!formatCursor.isAfterLast()) {
                CursorReader formatReader = new CursorReader(formatCursor);
                int packageVersion = formatReader.getInt("package_version");
                String mimeType = formatReader.getString("mime_type");
                int modifiedAt = formatReader.getInt("modified_at");
                String url = formatReader.getString("url");
                Resource.Format format = new Resource.Format(packageVersion, mimeType, modifiedAt, url);
                resource.addFormat(format);
                formatCursor.moveToNext();
            }
            formatCursor.close();
        }
        cursor.close();
        return resource;
    }

    @Override
    public List<Resource> getResources(String languageSlug, String projectSlug) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Cursor resourceCursor = null;
        resourceCursor = languageSlug != null && !languageSlug.isEmpty() ? this.db.rawQuery("select r.*, lri.translation_words_assignments_url from resource as r left join legacy_resource_info as lri on lri.resource_id=r.id where r.project_id in (  select id from project where slug=? and source_language_id in (   select id from source_language where slug=?) ) order by r.slug desc", new String[]{projectSlug, languageSlug}) : this.db.rawQuery("select sl.slug as source_language_slug, r.*, lri.translation_words_assignments_url from resource as r left join legacy_resource_info as lri on lri.resource_id=r.id left join project as p on p.id=r.project_id left join (  select id, slug from source_language ) as sl on sl.id=p.source_language_id where p.slug=? order by r.slug asc", new String[]{projectSlug});
        resourceCursor.moveToFirst();
        while (!resourceCursor.isAfterLast()) {
            CursorReader reader = new CursorReader(resourceCursor);
            long resourceId = reader.getLong("id");
            String slug = reader.getString("slug");
            String name = reader.getString("name");
            String translateMode = reader.getString("translate_mode");
            String type = reader.getString("type");
            String checkingLevel = reader.getString("checking_level");
            String comments = reader.getString("comments");
            int pubDate = reader.getInt("pub_date");
            String license = reader.getString("license");
            String version = reader.getString("version");
            String wordsAssignmentsUrl = reader.getString("translation_words_assignments_url");
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("translateMode", translateMode);
            status.put("checkingLevel", checkingLevel);
            status.put("comments", comments);
            status.put("pub_date", pubDate);
            status.put("license", license);
            status.put("version", version);
            Resource resource = new Resource(slug, name, type, wordsAssignmentsUrl, status);
            Cursor formatCursor = this.db.rawQuery("select * from resource_format where resource_id=" + resourceId, null);
            formatCursor.moveToFirst();
            while (!formatCursor.isAfterLast()) {
                CursorReader formatReader = new CursorReader(formatCursor);
                int packageVersion = formatReader.getInt("package_version");
                String mimeType = formatReader.getString("mime_type");
                int modifiedAt = formatReader.getInt("modified_at");
                String url = formatReader.getString("url");
                Resource.Format format = new Resource.Format(packageVersion, mimeType, modifiedAt, url);
                resource.addFormat(format);
                formatCursor.moveToNext();
            }
            formatCursor.close();
            resources.add(resource);
            resourceCursor.moveToNext();
        }
        resourceCursor.close();
        return resources;
    }

    @Override
    public Catalog getCatalog(String catalogSlug) {
        Catalog catalog = null;
        Cursor cursor = this.db.rawQuery("select id, url, modified_at from catalog where slug=?", new String[]{catalogSlug});
        if (cursor.moveToFirst()) {
            CursorReader reader = new CursorReader(cursor);
            String url = reader.getString("url");
            int modifiedAt = reader.getInt("modified_at");
            catalog = new Catalog(catalogSlug, url, modifiedAt);
            catalog._dbInfo.rowId = reader.getLong("id");
        }
        cursor.close();
        return catalog;
    }

    @Override
    public List<Catalog> getCatalogs() {
        Cursor cursor = this.db.rawQuery("select * from catalog", null);
        ArrayList<Catalog> catalogs = new ArrayList<Catalog>();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            CursorReader reader = new CursorReader(cursor);
            String slug = reader.getString("slug");
            String url = reader.getString("url");
            int modifiedAt = reader.getInt("modified_at");
            Catalog catalog = new Catalog(slug, url, modifiedAt);
            catalog._dbInfo.rowId = reader.getLong("id");
            catalogs.add(catalog);
            cursor.moveToNext();
        }
        cursor.close();
        return catalogs;
    }

    @Override
    public Versification getVersification(String sourceLanguageSlug, String versificationSlug) {
        Versification versification = null;
        Cursor cursor = this.db.rawQuery("select v.id, v.slug, vn.name from versification_name as vn left join versification as v on v.id=vn.versification_id left join source_language as sl on sl.id=vn.source_language_id where sl.slug=? and v.slug=?", new String[]{sourceLanguageSlug, versificationSlug});
        if (cursor.moveToFirst()) {
            CursorReader reader = new CursorReader(cursor);
            String slug = reader.getString("slug");
            String name = reader.getString("name");
            versification = new Versification(slug, name);
            versification._dbInfo.rowId = reader.getLong("id");
        }
        cursor.close();
        return versification;
    }

    @Override
    public List<Versification> getVersifications(String sourceLanguageSlug) {
        Cursor cursor = this.db.rawQuery("select vn.name, v.slug, v.id from versification_name as vn left join versification as v on v.id=vn.versification_id left join source_language as sl on sl.id=vn.source_language_id where sl.slug=?", new String[]{sourceLanguageSlug});
        ArrayList<Versification> versifications = new ArrayList<Versification>();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            CursorReader reader = new CursorReader(cursor);
            String slug = reader.getString("slug");
            String name = reader.getString("name");
            Versification versification = new Versification(slug, name);
            versification._dbInfo.rowId = reader.getLong("id");
            versifications.add(versification);
            cursor.moveToNext();
        }
        cursor.close();
        return versifications;
    }

    @Override
    public List<ChunkMarker> getChunkMarkers(String projectSlug, String versificationSlug) {
        Cursor cursor = this.db.rawQuery("select cm.id, cm.chapter, cm.verse from chunk_marker as cm left join versification as v on v.id=cm.versification_id where v.slug=? and cm.project_slug=?", new String[]{versificationSlug, projectSlug});
        ArrayList<ChunkMarker> chunkMarkers = new ArrayList<ChunkMarker>();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            CursorReader reader = new CursorReader(cursor);
            String chapter = reader.getString("chapter");
            String verse = reader.getString("verse");
            ChunkMarker chunkMarker = new ChunkMarker(chapter, verse);
            chunkMarker._dbInfo.rowId = reader.getLong("id");
            chunkMarkers.add(chunkMarker);
            cursor.moveToNext();
        }
        cursor.close();
        return chunkMarkers;
    }

    @Override
    public List<Questionnaire> getQuestionnaires() {
        Cursor cursor = this.db.rawQuery("select * from questionnaire", null);
        ArrayList<Questionnaire> questionnaires = new ArrayList<Questionnaire>();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            CursorReader reader = new CursorReader(cursor);
            String slug = reader.getString("language_slug");
            String name = reader.getString("language_name");
            String direction = reader.getString("language_direction");
            long tdId = reader.getLong("td_id");
            Questionnaire questionnaire = new Questionnaire(slug, name, direction, tdId);
            questionnaire._dbInfo.rowId = reader.getLong("id");
            questionnaires.add(questionnaire);
            cursor.moveToNext();
        }
        cursor.close();
        return questionnaires;
    }

    @Override
    public List<Question> getQuestions(long questionnaireTDId) {
        Cursor cursor = this.db.rawQuery("select * from question where questionnaire_id=" + questionnaireTDId, null);
        ArrayList<Question> questions = new ArrayList<Question>();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            CursorReader reader = new CursorReader(cursor);
            String text = reader.getString("text");
            String help = reader.getString("help");
            boolean isRequired = reader.getBoolean("is_required");
            String inputType = reader.getString("input_type");
            int sort = reader.getInt("sort");
            long dependsOn = reader.getInt("depends_on");
            long tdId = reader.getInt("td_id");
            Question question = new Question(text, help, isRequired, inputType, sort, dependsOn, tdId);
            question._dbInfo.rowId = reader.getLong("id");
            questions.add(question);
            cursor.moveToNext();
        }
        cursor.close();
        return questions;
    }

    private static class CursorReader {
        private final Cursor cursor;

        public CursorReader(Cursor cursor) {
            this.cursor = cursor;
        }

        public String getString(String key) {
            return this.cursor.getString(this.cursor.getColumnIndexOrThrow(key));
        }

        public long getLong(String key) {
            return this.cursor.getLong(this.cursor.getColumnIndexOrThrow(key));
        }

        public int getInt(String key) {
            return this.cursor.getInt(this.cursor.getColumnIndexOrThrow(key));
        }

        public boolean getBoolean(String key) {
            return this.cursor.getInt(this.cursor.getColumnIndexOrThrow(key)) > 0;
        }
    }

    private static class WhereClause {
        public final String statement;
        public final String[] arguments;

        private WhereClause(String statement, String[] values) {
            this.statement = statement;
            this.arguments = values;
        }

        public static WhereClause prepare(ContentValues values, String[] uniqueColumns) {
            ArrayList<String> stringColumns = new ArrayList<String>();
            ArrayList<String> numberColumns = new ArrayList<String>();
            for (String key : uniqueColumns) {
                if (values.get(key) instanceof String) {
                    stringColumns.add(key);
                    continue;
                }
                numberColumns.add(key);
            }
            String whereStmt = "";
            if (stringColumns.size() > 0) {
                whereStmt = TextUtils.join((CharSequence)"=? and ", stringColumns) + "=?";
            }
            if (numberColumns.size() > 0) {
                if (!whereStmt.isEmpty()) {
                    whereStmt = whereStmt + " and ";
                }
                ArrayList<String> expressions = new ArrayList<String>();
                for (String key : numberColumns) {
                    expressions.add(key + "=" + values.get(key));
                }
                whereStmt = whereStmt + TextUtils.join((CharSequence)" and ", expressions);
            }
            String[] uniqueValues = new String[stringColumns.size()];
            for (int i = 0; i < stringColumns.size(); ++i) {
                uniqueValues[i] = String.valueOf(values.get((String)stringColumns.get(i)));
            }
            return new WhereClause(whereStmt, uniqueValues);
        }
    }
}

