/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.door43client;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.unfoldingword.door43client.Door43Client;
import org.unfoldingword.door43client.Library;
import org.unfoldingword.door43client.models.Catalog;
import org.unfoldingword.door43client.models.Category;
import org.unfoldingword.door43client.models.ChunkMarker;
import org.unfoldingword.door43client.models.Project;
import org.unfoldingword.door43client.models.Resource;
import org.unfoldingword.door43client.models.SourceLanguage;
import org.unfoldingword.door43client.models.Versification;
import org.unfoldingword.resourcecontainer.ContainerTools;
import org.unfoldingword.tools.http.GetRequest;

public class LegacyTools {
    public static void injectGlobalCatalogs(Library library, String host) throws Exception {
        host = host != null && !host.trim().isEmpty() ? host : "http://td.unfoldingword.org";
        library.addCatalog(new Catalog("langnames", host + "/exports/langnames.json", 0));
        library.addCatalog(new Catalog("new-language-questions", host + "/api/questionnaire/", 0));
        library.addCatalog(new Catalog("temp-langnames", host + "/api/templanguages/", 0));
        library.addCatalog(new Catalog("approved-temp-langnames", host + "/api/templanguages/assignment/changed/", 0));
    }

    public static void processCatalog(Library library, String data, Door43Client.OnProgressListener listener) throws Exception {
        JSONArray projects = new JSONArray(data);
        for (int i = 0; i < projects.length(); ++i) {
            JSONObject pJson = projects.getJSONObject(i);
            if (listener != null) {
                listener.onProgress(pJson.getString("slug"), projects.length(), i + 1);
            }
            LegacyTools.downloadSourceLanguages(library, pJson, null);
        }
    }

    private static void downloadSourceLanguages(Library library, JSONObject pJson, Door43Client.OnProgressListener listener) throws Exception {
        GetRequest request = new GetRequest(new URL(pJson.getString("lang_catalog")));
        String response = request.read();
        if (request.getResponseCode() != 200) {
            throw new Exception(request.getResponseMessage());
        }
        String chunksUrl = "";
        if (!pJson.getString("slug").toLowerCase().equals("obs")) {
            chunksUrl = "https://api.unfoldingword.org/bible/txt/1/" + pJson.getString("slug") + "/chunks.json";
        }
        JSONArray languages = new JSONArray(response);
        for (int i = 0; i < languages.length(); ++i) {
            JSONObject lJson = languages.getJSONObject(i);
            if (listener != null) {
                listener.onProgress(lJson.getJSONObject("language").getString("slug") + pJson.getString("slug"), languages.length(), i + 1);
            }
            SourceLanguage sl = new SourceLanguage(lJson.getJSONObject("language").getString("slug"), lJson.getJSONObject("language").getString("name"), lJson.getJSONObject("language").getString("direction"));
            long languageId = library.addSourceLanguage(sl);
            library.addVersification(new Versification("en-US", "American English"), languageId);
            Project project = new Project(pJson.getString("slug"), lJson.getJSONObject("project").getString("name"), lJson.getJSONObject("project").getString("desc"), null, pJson.getInt("sort"), chunksUrl);
            ArrayList<Category> categories = new ArrayList<Category>();
            if (pJson.has("meta")) {
                for (int j = 0; j < pJson.getJSONArray("meta").length(); ++j) {
                    String slug = pJson.getJSONArray("meta").getString(j);
                    categories.add(new Category(slug, lJson.getJSONObject("project").getJSONArray("meta").getString(j)));
                }
            }
            long projectId = library.addProject(project, categories, languageId);
            LegacyTools.downloadResources(library, projectId, pJson, languageId, lJson);
        }
        if (!chunksUrl.isEmpty()) {
            LegacyTools.downloadChunks(library, chunksUrl, "en", pJson.getString("slug"));
        }
    }

    private static void downloadResources(Library library, long projectId, JSONObject pJson, long languageId, JSONObject lJson) throws Exception {
        GetRequest request = new GetRequest(new URL(lJson.getString("res_catalog")));
        String response = request.read();
        if (request.getResponseCode() != 200) {
            throw new Exception(request.getResponseMessage());
        }
        JSONArray resources = new JSONArray(response);
        for (int i = 0; i < resources.length(); ++i) {
            HashMap<String, Object> tnSourceTranslation;
            ArrayList sourceTranslations;
            String translateMode;
            JSONObject rJson = resources.getJSONObject(i);
            switch (rJson.getString("slug").toLowerCase()) {
                case "obs": 
                case "ulb": {
                    translateMode = "all";
                    break;
                }
                default: {
                    translateMode = "gl";
                }
            }
            Map<String, Object> status = LegacyTools.jsonToMap(rJson.getJSONObject("status"));
            status.put("translate_mode", translateMode);
            status.put("pub_date", rJson.getJSONObject("status").getString("publish_date"));
            Resource resource = new Resource(rJson.getString("slug"), rJson.getString("name"), "book", rJson.getString("tw_cat"), status);
            Resource.Format format = new Resource.Format(7, ContainerTools.typeToMime((String)"book"), rJson.getInt("date_modified"), rJson.getString("source"));
            resource.addFormat(format);
            long resourceId = library.addResource(resource, projectId);
            if (rJson.has("notes") && !rJson.getString("notes").isEmpty()) {
                status.put("translate_mode", "gl");
                sourceTranslations = new ArrayList();
                tnSourceTranslation = new HashMap<String, Object>();
                tnSourceTranslation.put("language_slug", lJson.getJSONObject("language").getString("slug"));
                tnSourceTranslation.put("resource_slug", "tn");
                tnSourceTranslation.put("version", resource.status.get("version"));
                sourceTranslations.add(tnSourceTranslation);
                status.put("source_translations", sourceTranslations);
                Resource tnResource = new Resource("tn", "translationNotes", "help", null, status);
                Resource.Format tnFormat = new Resource.Format(7, ContainerTools.typeToMime((String)"help"), rJson.getInt("date_modified"), rJson.getString("notes"));
                tnResource.addFormat(tnFormat);
                library.addResource(tnResource, projectId);
            }
            if (rJson.has("checking_questions") && !rJson.getString("checking_questions").isEmpty()) {
                status.put("translate_mode", "gl");
                sourceTranslations = new ArrayList();
                tnSourceTranslation = new HashMap();
                tnSourceTranslation.put("language_slug", lJson.getJSONObject("language").getString("slug"));
                tnSourceTranslation.put("resource_slug", "tq");
                tnSourceTranslation.put("version", resource.status.get("version"));
                sourceTranslations.add(tnSourceTranslation);
                status.put("source_translations", sourceTranslations);
                Resource tqResource = new Resource("tq", "translationQuestions", "help", null, status);
                Resource.Format tqFormat = new Resource.Format(7, ContainerTools.typeToMime((String)"help"), rJson.getInt("date_modified"), rJson.getString("checking_questions"));
                tqResource.addFormat(tqFormat);
                library.addResource(tqResource, projectId);
            }
            if (!rJson.has("terms") || rJson.getString("terms").isEmpty()) continue;
            String slug = pJson.getString("slug").equals("obs") ? "bible-obs" : "bible";
            String name = "translationWords" + (pJson.getString("slug").equals("obs") ? " OBS" : "");
            Project wordsProject = new Project(slug, name, "", null, 100, "");
            long wordsProjectId = library.addProject(wordsProject, null, languageId);
            status.put("translate_mode", "gl");
            ArrayList sourceTranslations2 = new ArrayList();
            HashMap<String, Object> twSourceTranslation = new HashMap<String, Object>();
            twSourceTranslation.put("language_slug", lJson.getJSONObject("language").getString("slug"));
            twSourceTranslation.put("resource_slug", "tw");
            twSourceTranslation.put("version", resource.status.get("version"));
            sourceTranslations2.add(twSourceTranslation);
            status.put("source_translations", sourceTranslations2);
            Resource twResource = new Resource("tw", "translationWords", "dict", null, status);
            Resource.Format twFormat = new Resource.Format(7, ContainerTools.typeToMime((String)"dict"), rJson.getInt("date_modified"), rJson.getString("terms"));
            twResource.addFormat(twFormat);
            library.addResource(twResource, wordsProjectId);
        }
    }

    private static void downloadChunks(Library library, String chunksUrl, String sourceLanguageSlug, String projectSlug) throws Exception {
        String versificationSlug = "en-US";
        Versification v = library.getVersification(sourceLanguageSlug, versificationSlug);
        if (v != null) {
            GetRequest request = new GetRequest(new URL(chunksUrl));
            String data = request.read();
            JSONArray chunks = new JSONArray(data);
            for (int i = 0; i < chunks.length(); ++i) {
                JSONObject chunk = chunks.getJSONObject(i);
                ChunkMarker cm = new ChunkMarker(chunk.getString("chp"), chunk.getString("firstvs"));
                library.addChunkMarker(cm, projectSlug, v._dbInfo.rowId);
            }
        } else {
            System.console().writer().write("Unknown versification " + versificationSlug + " while downloading chunks for project " + projectSlug);
        }
    }

    public static Map<String, Object> jsonToMap(JSONObject json) throws JSONException {
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (json != JSONObject.NULL) {
            retMap = LegacyTools.toMap(json);
        }
        return retMap;
    }

    public static Map<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            List<Object> value = object.get(key);
            if (value instanceof JSONArray) {
                value = LegacyTools.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = LegacyTools.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    public static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = LegacyTools.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = LegacyTools.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }
}

