/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.door43client;

import android.content.Context;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.unfoldingword.door43client.FileUtil;
import org.unfoldingword.door43client.Index;
import org.unfoldingword.door43client.LegacyTools;
import org.unfoldingword.door43client.Library;
import org.unfoldingword.door43client.SQLiteHelper;
import org.unfoldingword.door43client.models.Catalog;
import org.unfoldingword.door43client.models.Project;
import org.unfoldingword.door43client.models.Question;
import org.unfoldingword.door43client.models.Questionnaire;
import org.unfoldingword.door43client.models.Resource;
import org.unfoldingword.door43client.models.SourceLanguage;
import org.unfoldingword.door43client.models.TargetLanguage;
import org.unfoldingword.resourcecontainer.ContainerTools;
import org.unfoldingword.resourcecontainer.ResourceContainer;
import org.unfoldingword.tools.http.GetRequest;
import org.unfoldingword.tools.http.Request;

public class Door43Client {
    private static final OnLogListener defaultLogListener = new OnLogListener(){

        @Override
        public void onInfo(String message) {
        }

        @Override
        public void onWarning(String message) {
        }

        @Override
        public void onError(String message, Exception ex) {
        }
    };
    private final File resourceDir;
    private final Library library;
    private String globalCatalogHost = null;
    private OnLogListener logListener = defaultLogListener;

    public Door43Client(Context context, String databaseName, File resourceDir) throws IOException {
        String line;
        this.resourceDir = resourceDir;
        URL resource = this.getClass().getClassLoader().getResource("schema.sqlite");
        File sqliteFile = new File(resource.getPath());
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(sqliteFile)));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line).append("\n");
        }
        SQLiteHelper helper = new SQLiteHelper(context, sb.toString(), databaseName);
        this.library = new Library(helper);
    }

    public void setLogger(OnLogListener listener) {
        this.logListener = listener == null ? defaultLogListener : listener;
    }

    @Deprecated
    public void setGlobalCatalogServer(String host) {
        this.globalCatalogHost = host;
    }

    public Index index() {
        return this.library;
    }

    public void updatePrimaryIndex(String url, OnProgressListener listener) throws Exception {
        this.library.beginTransaction();
        try {
            LegacyTools.injectGlobalCatalogs(this.library, this.globalCatalogHost);
            GetRequest getPrimaryCatalog = new GetRequest(new URL(url));
            getPrimaryCatalog.setProgressListener(new Request.OnProgressListener(){

                public void onProgress(long max, long progress) {
                }

                public void onIndeterminate() {
                }
            });
            String data = getPrimaryCatalog.read();
            LegacyTools.processCatalog(this.library, data, listener);
        }
        catch (Exception e) {
            this.library.endTransaction(false);
            throw e;
        }
        this.library.endTransaction(true);
    }

    public void updateCatalogIndex(String catalogSlug, OnProgressListener listener) throws Exception {
        Catalog cat = this.library.getCatalog(catalogSlug);
        if (cat == null) {
            throw new Exception("Unknown catalog");
        }
        GetRequest request = new GetRequest(new URL(cat.url));
        String data = request.read();
        if (request.getResponseCode() != 200) {
            throw new Exception(request.getResponseMessage());
        }
        this.library.beginTransaction();
        try {
            switch (catalogSlug) {
                case "langnames": {
                    this.indexTargetLanguageCatalog(data, listener);
                    break;
                }
                case "new-language-questions": {
                    this.indexNewLanguageQuestionsCatalog(data, listener);
                    break;
                }
                case "temp-langnames": {
                    this.indexTempLanguagesCatalog(data, listener);
                    break;
                }
                case "approved-temp-langnames": {
                    this.indexApprovedTempLanguagesCatalog(data, listener);
                    break;
                }
                default: {
                    throw new Exception("Parsing this catalog has not been implemented");
                }
            }
        }
        catch (Exception e) {
            this.library.endTransaction(false);
            throw e;
        }
        this.library.endTransaction(true);
    }

    private void indexTargetLanguageCatalog(String data, OnProgressListener listener) throws Exception {
        JSONArray languages = new JSONArray(data);
        for (int i = 0; i < languages.length(); ++i) {
            JSONObject l = languages.getJSONObject(i);
            boolean isGateway = l.has("gl") ? l.getBoolean("gl") : false;
            TargetLanguage language = new TargetLanguage(l.getString("lc"), l.getString("ln"), l.getString("ang"), l.getString("ld"), l.getString("lr"), isGateway);
            if (!this.library.addTargetLanguage(language)) {
                this.logListener.onWarning("Failed to add the target language: " + language.slug);
            }
            if (listener == null) continue;
            listener.onProgress("langnames", languages.length(), i + 1);
        }
    }

    private void indexNewLanguageQuestionsCatalog(String data, OnProgressListener listener) throws Exception {
        JSONObject obj = new JSONObject(data);
        JSONArray languages = obj.getJSONArray("languages");
        for (int i = 0; i < languages.length(); ++i) {
            JSONObject qJson = languages.getJSONObject(i);
            Questionnaire questionnaire = new Questionnaire(qJson.getString("slug"), qJson.getString("name"), qJson.getString("dir"), qJson.getLong("questionnaire_id"));
            long questionnaireId = this.library.addQuestionnaire(questionnaire);
            for (int j = 0; j < qJson.getJSONArray("questions").length(); ++j) {
                JSONObject questionJson = qJson.getJSONArray("questions").getJSONObject(j);
                long dependsOnId = questionJson.isNull("depends_on") ? 0L : questionJson.getLong("depends_on");
                Question question = new Question(questionJson.getString("text"), questionJson.getString("help"), questionJson.getBoolean("required"), questionJson.getString("input_type"), questionJson.getInt("sort"), dependsOnId, questionJson.getLong("id"));
                this.library.addQuestion(question, questionnaireId);
                if (languages.length() != 1 || listener == null) continue;
                listener.onProgress("new-language-questions", qJson.getJSONArray("questions").length(), j + 1);
            }
            if (languages.length() <= 1 || listener == null) continue;
            listener.onProgress("new-language-questions", qJson.getJSONArray("questions").length(), i + 1);
        }
    }

    private void indexTempLanguagesCatalog(String data, OnProgressListener listener) throws Exception {
        JSONArray languages = new JSONArray(data);
        for (int i = 0; i < languages.length(); ++i) {
            JSONObject l = languages.getJSONObject(i);
            boolean isGateway = l.has("gl") ? l.getBoolean("gl") : false;
            TargetLanguage language = new TargetLanguage(l.getString("lc"), l.getString("ln"), l.getString("ang"), l.getString("ld"), l.getString("lr"), isGateway);
            if (!this.library.addTempTargetLanguage(language)) {
                this.logListener.onWarning("Failed to add the temp target language: " + language.slug);
            }
            if (listener == null) continue;
            listener.onProgress("temp-langnames", languages.length(), i + 1);
        }
    }

    private void indexApprovedTempLanguagesCatalog(String data, OnProgressListener listener) throws Exception {
        JSONArray languages = new JSONArray(data);
        for (int i = 0; i < languages.length(); ++i) {
            JSONObject l = languages.getJSONObject(i);
            Iterator keys = l.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (this.library.setApprovedTargetLanguage(key, l.getString(key))) continue;
                this.logListener.onWarning("Failed to approve the temp target language: " + key + " as " + l.getString(key));
            }
            if (listener == null) continue;
            listener.onProgress("approved-temp-langnames", languages.length(), i + 1);
        }
    }

    public ResourceContainer downloadResourceContainer(String sourceLanguageSlug, String projectSlug, String resourceSlug) throws Exception {
        File path = this.downloadFutureCompatibleResourceContainer(sourceLanguageSlug, projectSlug, resourceSlug);
        Resource r = this.library.getResource(sourceLanguageSlug, projectSlug, resourceSlug);
        if (r == null) {
            throw new Exception("Unknown resource");
        }
        String data = FileUtil.readFileToString(path);
        FileUtil.deleteQuietly(path);
        return this.convertLegacyResource(sourceLanguageSlug, projectSlug, resourceSlug, data);
    }

    public File downloadFutureCompatibleResourceContainer(String sourceLanguageSlug, String projectSlug, String resourceSlug) throws Exception {
        Resource r = this.library.getResource(sourceLanguageSlug, projectSlug, resourceSlug);
        if (r == null) {
            throw new Exception("Unknown resource");
        }
        Resource.Format containerFormat = Door43Client.getResourceContainerFormat(r.formats);
        if (containerFormat == null) {
            throw new Exception("Missing resource container format");
        }
        String containerSlug = ContainerTools.makeSlug((String)sourceLanguageSlug, (String)projectSlug, (String)resourceSlug);
        File containerDir = new File(this.resourceDir, containerSlug);
        File destFile = new File(this.resourceDir, containerSlug + "." + "tsrc");
        FileUtil.deleteQuietly(destFile);
        FileUtil.deleteQuietly(containerDir);
        destFile.getParentFile().mkdirs();
        if (containerFormat.url == null || containerFormat.url.isEmpty()) {
            throw new Exception("Missing resource format url");
        }
        GetRequest request = new GetRequest(new URL(containerFormat.url));
        request.download(destFile);
        if (request.getResponseCode() != 200) {
            FileUtil.deleteQuietly(destFile);
            throw new Exception(request.getResponseMessage());
        }
        return destFile;
    }

    private static Resource.Format getResourceContainerFormat(List<Resource.Format> formats) {
        for (Resource.Format f : formats) {
            if (!f.mimeType.matches("application/tsrc\\+.+")) continue;
            return f;
        }
        return null;
    }

    @Deprecated
    public ResourceContainer convertLegacyResource(String sourceLanguageSlug, String projectSlug, String resourceSlug, String data) throws Exception {
        String containerSlug = ContainerTools.makeSlug((String)sourceLanguageSlug, (String)projectSlug, (String)resourceSlug);
        File containerDir = new File(this.resourceDir, containerSlug);
        SourceLanguage language = this.library.getSourceLanguage(sourceLanguageSlug);
        if (language == null) {
            throw new Exception("Missing language");
        }
        JSONObject lJson = language.toJSON();
        Project project = this.library.getProject(sourceLanguageSlug, projectSlug);
        if (project == null) {
            throw new Exception("Missing project");
        }
        JSONObject pJson = project.toJSON();
        Resource resource = this.library.getResource(sourceLanguageSlug, projectSlug, resourceSlug);
        if (resource == null) {
            throw new Exception("Missing resource");
        }
        Resource.Format format = Door43Client.getResourceContainerFormat(resource.formats);
        if (format == null) {
            throw new Exception("Missing resource container format");
        }
        JSONObject rJson = resource.toJSON();
        JSONObject properties = new JSONObject();
        properties.put("language", (Object)lJson);
        properties.put("project", (Object)pJson);
        properties.put("resource", (Object)rJson);
        properties.put("modified_at", format.modifiedAt);
        if (resource.wordsAssignmentsUrl != null && !resource.wordsAssignmentsUrl.isEmpty()) {
            GetRequest request = new GetRequest(new URL(resource.wordsAssignmentsUrl));
            String wordsData = request.read();
            if (request.getResponseCode() < 300) {
                try {
                    JSONArray words = new JSONArray(wordsData);
                    JSONObject assignmentsJson = new JSONObject();
                    for (int c = 0; c < words.length(); ++c) {
                        JSONObject chapter = words.getJSONObject(c);
                        JSONObject chapterAssignment = new JSONObject();
                        for (int f = 0; f < chapter.getJSONArray("frames").length(); ++f) {
                            JSONObject frame = chapter.getJSONArray("frames").getJSONObject(f);
                            JSONArray frameAssignment = new JSONArray();
                            for (int w = 0; w < frame.getJSONArray("items").length(); ++w) {
                                JSONObject word = frame.getJSONArray("items").getJSONObject(w);
                                String twProjSlug = projectSlug.equals("obs") ? "bible-obs" : "bible";
                                frameAssignment.put((Object)("//" + twProjSlug + "/tw/" + word.getString("id")));
                            }
                            chapterAssignment.put(frame.getString("id"), (Object)frameAssignment);
                        }
                        assignmentsJson.put(chapter.getString("id"), (Object)chapterAssignment);
                    }
                    properties.put("tw_assignments", (Object)assignmentsJson);
                }
                catch (Exception e) {
                    this.logListener.onWarning(e.getMessage());
                }
            }
        }
        ResourceContainer container = ContainerTools.convertResource((String)data, (File)containerDir, (JSONObject)properties);
        ResourceContainer.close((File)new File(containerDir.getPath()));
        return container;
    }

    public ResourceContainer openResourceContainer(String sourceLanguageSlug, String projectSlug, String resourceSlug) {
        return null;
    }

    public String closeResourceContainer(String sourceLanguageSlug, String projectSlug, String resourceSlug) {
        return null;
    }

    public List<JSONObject> listResourceContainers() {
        return null;
    }

    public List<String> getProjectUpdates(String sourceLanguageSlug) {
        return null;
    }

    public List<String> getSourceLanguageUpdates() {
        return null;
    }

    public static interface OnLogListener {
        public void onInfo(String var1);

        public void onWarning(String var1);

        public void onError(String var1, Exception var2);
    }

    public static interface OnProgressListener {
        public void onProgress(String var1, long var2, long var4);
    }
}

