/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.door43client;

import android.content.Context;
import android.content.ContextWrapper;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import java.io.File;

public class DatabaseContext
extends ContextWrapper {
    private final File dir;

    public DatabaseContext(Context base, File databaseDir) {
        super(base);
        this.dir = databaseDir;
    }

    public File getDatabasePath(String name) {
        File result;
        String dbfile = this.dir.getAbsolutePath() + File.separator + name;
        if (!dbfile.endsWith(".db")) {
            dbfile = dbfile + ".db";
        }
        if (!(result = new File(dbfile)).getParentFile().exists()) {
            result.getParentFile().mkdirs();
        }
        return result;
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory, DatabaseErrorHandler errorHandler) {
        return this.openOrCreateDatabase(name, mode, factory);
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
        return SQLiteDatabase.openOrCreateDatabase((File)this.getDatabasePath(name), null);
    }
}

