/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.helm.util;

import java.io.Closeable;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import javax.annotation.WillNotClose;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a\u001e\u0010\u0006\u001a\u00020\u0007*\u00020\f2\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a\u001e\u0010\u0006\u001a\u00020\u0007*\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a\u001e\u0010\u000e\u001a\u00020\u0003*\u00020\f2\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a\u001e\u0010\u000e\u001a\u00020\u0003*\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"DefaultBufferSize", "", "DefaultDigestAlgorithm", "", "HEX_ALPHABET", "", "calculateDigest", "", "channel", "Ljava/nio/channels/ReadableByteChannel;", "algorithm", "bufferSize", "Ljava/io/File;", "Ljava/nio/file/Path;", "calculateDigestHex", "safeClear", "", "Ljava/nio/ByteBuffer;", "helm-plugin"})
@SourceDebugExtension(value={"SMAP\nDigestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigestUtils.kt\norg/unbrokendome/gradle/plugins/helm/util/DigestUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,140:1\n13316#2,2:141\n*S KotlinDebug\n*F\n+ 1 DigestUtils.kt\norg/unbrokendome/gradle/plugins/helm/util/DigestUtilsKt\n*L\n115#1:141,2\n*E\n"})
public final class DigestUtilsKt {
    @NotNull
    private static final String DefaultDigestAlgorithm = "SHA-256";
    private static final int DefaultBufferSize = 8192;
    @NotNull
    private static final char[] HEX_ALPHABET;

    @NotNull
    public static final byte[] calculateDigest(@WillNotClose @NotNull ReadableByteChannel channel, @NotNull String algorithm, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize);
        while (true) {
            Intrinsics.checkNotNull((Object)buffer);
            DigestUtilsKt.safeClear(buffer);
            int bytesRead = channel.read(buffer);
            if (bytesRead == -1) break;
            buffer.flip();
            digest.update(buffer);
        }
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] calculateDigest$default(ReadableByteChannel readableByteChannel, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = DefaultDigestAlgorithm;
        }
        if ((n2 & 4) != 0) {
            n = 8192;
        }
        return DigestUtilsKt.calculateDigest(readableByteChannel, string, n);
    }

    private static final void safeClear(ByteBuffer $this$safeClear) {
        $this$safeClear.position(0);
        $this$safeClear.limit($this$safeClear.capacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] calculateDigest(@NotNull Path $this$calculateDigest, @NotNull String algorithm, int bufferSize) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$calculateDigest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        long fileSize = Files.size($this$calculateDigest);
        int actualBufferSize = (int)Math.min(fileSize, (long)bufferSize);
        Object object = new OpenOption[]{StandardOpenOption.READ};
        object = FileChannel.open($this$calculateDigest, object);
        Throwable throwable = null;
        try {
            FileChannel channel = (FileChannel)object;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)channel);
            byArray = DigestUtilsKt.calculateDigest(channel, algorithm, actualBufferSize);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return byArray;
    }

    public static /* synthetic */ byte[] calculateDigest$default(Path path, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = DefaultDigestAlgorithm;
        }
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        return DigestUtilsKt.calculateDigest(path, string, n);
    }

    @NotNull
    public static final byte[] calculateDigest(@NotNull File $this$calculateDigest, @NotNull String algorithm, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateDigest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Path path = $this$calculateDigest.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return DigestUtilsKt.calculateDigest(path, algorithm, bufferSize);
    }

    public static /* synthetic */ byte[] calculateDigest$default(File file, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = DefaultDigestAlgorithm;
        }
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        return DigestUtilsKt.calculateDigest(file, string, n);
    }

    @NotNull
    public static final String calculateDigestHex(@NotNull Path $this$calculateDigestHex, @NotNull String algorithm, int bufferSize) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$calculateDigestHex, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        byte[] digestBytes = DigestUtilsKt.calculateDigest($this$calculateDigestHex, algorithm, bufferSize);
        int n = digestBytes.length * 2;
        StringBuilder $this$calculateDigestHex_u24lambda_u242 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        byte[] $this$forEach$iv = digestBytes;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (int i = 0; i < n2; ++i) {
            byte element$iv;
            byte by = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            $this$calculateDigestHex_u24lambda_u242.append(HEX_ALPHABET[by >> 4 & 0xF]);
            $this$calculateDigestHex_u24lambda_u242.append(HEX_ALPHABET[by & 0xF]);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    public static /* synthetic */ String calculateDigestHex$default(Path path, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = DefaultDigestAlgorithm;
        }
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        return DigestUtilsKt.calculateDigestHex(path, string, n);
    }

    @NotNull
    public static final String calculateDigestHex(@NotNull File $this$calculateDigestHex, @NotNull String algorithm, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateDigestHex, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Path path = $this$calculateDigestHex.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return DigestUtilsKt.calculateDigestHex(path, algorithm, bufferSize);
    }

    public static /* synthetic */ String calculateDigestHex$default(File file, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = DefaultDigestAlgorithm;
        }
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        return DigestUtilsKt.calculateDigestHex(file, string, n);
    }

    static {
        char[] cArray = "0123456789abcdef".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        HEX_ALPHABET = cArray;
    }
}

