/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.helm.command.rules;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.unbrokendome.gradle.plugins.helm.command.rules.DownloadClientPackageTaskRuleKt;
import org.unbrokendome.gradle.plugins.helm.command.rules.ExtractClientTaskRule;
import org.unbrokendome.gradle.plugins.helm.command.rules.ExtractClientTaskRuleKt;
import org.unbrokendome.gradle.plugins.helm.command.tasks.HelmDownloadClientPackage;
import org.unbrokendome.gradle.plugins.helm.command.tasks.HelmExtractClient;
import org.unbrokendome.gradle.pluginutils.rules.AbstractRule;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/unbrokendome/gradle/plugins/helm/command/rules/ExtractClientTaskRule;", "Lorg/unbrokendome/gradle/pluginutils/rules/AbstractRule;", "project", "Lorg/gradle/api/Project;", "baseExtractDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "(Lorg/gradle/api/Project;Lorg/gradle/api/provider/Provider;)V", "regex", "Lkotlin/text/Regex;", "apply", "", "domainObjectName", "", "getDescription", "helm-plugin"})
public final class ExtractClientTaskRule
extends AbstractRule {
    @NotNull
    private final Project project;
    @NotNull
    private final Provider<Directory> baseExtractDir;
    @NotNull
    private final Regex regex;

    public ExtractClientTaskRule(@NotNull Project project, @NotNull Provider<Directory> baseExtractDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(baseExtractDir, (String)"baseExtractDir");
        this.project = project;
        this.baseExtractDir = baseExtractDir;
        char c = '^';
        String string = ExtractClientTaskRuleKt.extractClientTaskName("(.*)");
        this.regex = new Regex(c + string + "$");
    }

    @NotNull
    public String getDescription() {
        return ExtractClientTaskRuleKt.extractClientTaskName("<version>");
    }

    public void apply(@NotNull String domainObjectName) {
        Intrinsics.checkNotNullParameter((Object)domainObjectName, (String)"domainObjectName");
        MatchResult matchResult = this.regex.matchEntire((CharSequence)domainObjectName);
        if (matchResult == null) {
            return;
        }
        MatchResult matchResult2 = matchResult;
        String helmClientVersion = (String)matchResult2.getGroupValues().get(1);
        TaskProvider downloadTask = this.project.getTasks().named(DownloadClientPackageTaskRuleKt.downloadClientTaskName(helmClientVersion), HelmDownloadClientPackage.class);
        this.project.getTasks().create(domainObjectName, HelmExtractClient.class, arg_0 -> ExtractClientTaskRule.apply$lambda$0((Function1)new Function1<HelmExtractClient, Unit>((TaskProvider<HelmDownloadClientPackage>)downloadTask, helmClientVersion, this){
            final /* synthetic */ TaskProvider<HelmDownloadClientPackage> $downloadTask;
            final /* synthetic */ String $helmClientVersion;
            final /* synthetic */ ExtractClientTaskRule this$0;
            {
                this.$downloadTask = $downloadTask;
                this.$helmClientVersion = $helmClientVersion;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(HelmExtractClient task) {
                Object[] objectArray = new Object[]{this.$downloadTask};
                task.dependsOn(objectArray);
                task.getVersion().set((Object)this.$helmClientVersion);
                task.getArchiveFile().set(this.$downloadTask.flatMap(arg_0 -> apply.1.invoke$lambda$0(apply.1.INSTANCE, arg_0)));
                task.getBaseDestinationDir().set(ExtractClientTaskRule.access$getBaseExtractDir$p(this.this$0));
            }

            private static final Provider invoke$lambda$0(Function1 $tmp0, Object in) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Provider)$tmp0.invoke(in);
            }
        }, arg_0));
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Provider access$getBaseExtractDir$p(ExtractClientTaskRule $this) {
        return $this.baseExtractDir;
    }
}

