/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.testsets.internal;

import com.google.common.eventbus.Subscribe;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.tasks.testing.Test;
import org.unbrokendome.gradle.plugins.testsets.dsl.TestSet;
import org.unbrokendome.gradle.plugins.testsets.internal.AbstractConventionPropertySource;
import org.unbrokendome.gradle.plugins.testsets.internal.conventions.ConventionHelper;
import org.unbrokendome.gradle.plugins.testsets.internal.conventions.ConventionProperty;
import org.unbrokendome.gradle.plugins.testsets.internal.events.TestSetAddedEvent;

public class TestTaskListener {
    private final Project project;

    public TestTaskListener(Project project) {
        this.project = project;
    }

    @Subscribe
    public void testSetAdded(TestSetAddedEvent event) {
        TestSet testSet = event.getTestSet();
        Test testTask = (Test)this.project.getTasks().create(testSet.getTestTaskName(), Test.class);
        ConventionHelper.applyConventionProperties((IConventionAware)testTask, new TestTaskConventionPropertySource(this.project, testSet));
    }

    private static class TestTaskConventionPropertySource
    extends AbstractConventionPropertySource {
        public TestTaskConventionPropertySource(Project project, TestSet testSet) {
            super(project, testSet);
        }

        @ConventionProperty(value="description")
        public String getDescription() {
            return "Runs the " + this.getTestSet().getName() + " tests";
        }

        @ConventionProperty(value="group")
        public String getGroup() {
            return "verification";
        }

        @ConventionProperty(value="testClassesDir")
        public File getTestClassesDir() {
            return this.getSourceSet().getOutput().getClassesDir();
        }

        @ConventionProperty(value="classpath")
        public FileCollection getClasspath() {
            return this.getSourceSet().getRuntimeClasspath();
        }
    }
}

